/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.gdface.utils.MatchPatternInfo;
import net.gdface.utils.TypeUtils;

public abstract class BaseStringMatchRules {
    private static final String RULE_FMT_REGEX = "^(?:<(.*?)>)?(.*)$";
    private final LinkedHashMap<String, StringMatchRule> rules = new LinkedHashMap();
    private final ReadWriteLock ruleLock = new ReentrantReadWriteLock();
    private static final StringMatchRule NULL_RULE = new StringMatchRule();
    protected final LoadingCache<String, StringMatchRule> portRuleCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, StringMatchRule>(){

        public StringMatchRule load(String portName) throws Exception {
            StringMatchRule r = BaseStringMatchRules.this.getRule(portName);
            return null == r ? NULL_RULE : r;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseStringMatchRules addRule(StringMatchRule rule) {
        Lock lock = this.ruleLock.writeLock();
        lock.lock();
        try {
            this.rules.put(rule.keyOfRule(), rule);
            BaseStringMatchRules baseStringMatchRules = this;
            return baseStringMatchRules;
        }
        finally {
            lock.unlock();
        }
    }

    public BaseStringMatchRules addRule(String rule) {
        StringMatchRule r = this.parseRule(rule);
        return this.addRule(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseStringMatchRules addRules(String rules) {
        LinkedHashMap<String, StringMatchRule> rs = this.parseRules(rules);
        Lock lock = this.ruleLock.writeLock();
        lock.lock();
        try {
            this.rules.putAll(rs);
            BaseStringMatchRules baseStringMatchRules = this;
            return baseStringMatchRules;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseStringMatchRules removeKey(String key) {
        Lock lock = this.ruleLock.writeLock();
        lock.lock();
        try {
            this.rules.remove(BaseStringMatchRules.stripQuoteOfPrefix(key));
            BaseStringMatchRules baseStringMatchRules = this;
            return baseStringMatchRules;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseStringMatchRules replace(String value) {
        StringMatchRule r = this.parseRule(value);
        Lock lock = this.ruleLock.writeLock();
        lock.lock();
        try {
            TypeUtils.replace(this.rules, r.keyOfRule(), r);
            BaseStringMatchRules baseStringMatchRules = this;
            return baseStringMatchRules;
        }
        finally {
            lock.unlock();
        }
    }

    public BaseStringMatchRules clearRules() {
        this.clearCache();
        Lock lock = this.ruleLock.writeLock();
        lock.lock();
        try {
            this.rules.clear();
            this.clearCache();
            BaseStringMatchRules baseStringMatchRules = this;
            return baseStringMatchRules;
        }
        finally {
            lock.unlock();
        }
    }

    public BaseStringMatchRules clearCache() {
        this.portRuleCache.asMap().clear();
        return this;
    }

    public Set<String> patterns() {
        Lock lock = this.ruleLock.readLock();
        lock.lock();
        try {
            Set<String> set = this.rules.keySet();
            return set;
        }
        finally {
            lock.unlock();
        }
    }

    public Collection<StringMatchRule> allRules() {
        Lock lock = this.ruleLock.readLock();
        lock.lock();
        try {
            Collection<StringMatchRule> collection = this.rules.values();
            return collection;
        }
        finally {
            lock.unlock();
        }
    }

    public int sizeOfRules() {
        Lock lock = this.ruleLock.readLock();
        lock.lock();
        try {
            int n = this.rules.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringMatchRule getRule(String input) {
        if (!Strings.isNullOrEmpty((String)input)) {
            Lock lock = this.ruleLock.readLock();
            lock.lock();
            try {
                StringMatchRule r = this.rules.get(BaseStringMatchRules.stripQuoteOfPrefix(input));
                if (null != r) {
                    StringMatchRule stringMatchRule = r;
                    return stringMatchRule;
                }
                final StringMatchRule inputPattern = StringMatchRule.create(input);
                Optional opt = Iterables.tryFind(this.rules.values(), (Predicate)new Predicate<StringMatchRule>(){

                    public boolean apply(StringMatchRule rule) {
                        return (!rule.patternInfo.isDefaultMatch() || null != rule.prefix && !rule.prefix.isDefaultMatch()) && rule.match(inputPattern);
                    }
                });
                StringMatchRule stringMatchRule = (StringMatchRule)opt.orNull();
                return stringMatchRule;
            }
            finally {
                lock.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(StringMatchRule matchRule) {
        int index = -1;
        if (null != matchRule && !matchRule.nullRule()) {
            Lock lock = this.ruleLock.readLock();
            lock.lock();
            try {
                for (StringMatchRule r : this.rules.values()) {
                    ++index;
                    if (!r.equals(matchRule)) continue;
                    int n = index;
                    return n;
                }
            }
            finally {
                lock.unlock();
            }
        }
        return index;
    }

    public static String stripQuoteOfPrefix(String pattern) {
        Pattern p;
        Matcher m;
        if (!Strings.isNullOrEmpty((String)pattern) && (m = (p = Pattern.compile(RULE_FMT_REGEX)).matcher(pattern)).matches()) {
            pattern = Strings.nullToEmpty((String)m.group(1)) + m.group(2);
        }
        return pattern;
    }

    public static String wrapMatchRule(String prefix, String portName) {
        return "<" + Strings.nullToEmpty((String)prefix) + ">" + Strings.nullToEmpty((String)portName);
    }

    public StringMatchRule getRuleCached(String input) {
        return (StringMatchRule)this.portRuleCache.getUnchecked((Object)input);
    }

    public StringMatchRule getRuleCached(String addationalPrefix, String input) {
        StringMatchRule rule = this.getRuleCached(input);
        if (rule.nullRule() && !Strings.isNullOrEmpty((String)addationalPrefix)) {
            StringMatchRule matchPatternInfo = StringMatchRule.create(input);
            if (null == matchPatternInfo.prefix) {
                String matchRule = BaseStringMatchRules.wrapMatchRule(addationalPrefix, matchPatternInfo.pattern);
                rule = this.getRuleCached(matchRule);
            }
        }
        return rule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringMatchRule getRuleByPattern(String pattern) {
        if (!Strings.isNullOrEmpty((String)pattern)) {
            pattern = BaseStringMatchRules.stripQuoteOfPrefix(pattern);
            Lock lock = this.ruleLock.readLock();
            lock.lock();
            try {
                StringMatchRule stringMatchRule = this.rules.get(pattern);
                return stringMatchRule;
            }
            finally {
                lock.unlock();
            }
        }
        return null;
    }

    public String toString() {
        Lock lock = this.ruleLock.readLock();
        lock.lock();
        try {
            String string = "BaseStringMatchRules [rules=" + this.rules + "]";
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    private static final List<String> elementsOf(String input, String delim) {
        ArrayList<String> list = new ArrayList<String>();
        if (input != null && delim != null) {
            StringTokenizer st = new StringTokenizer(input, delim);
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
        }
        return list;
    }

    protected LinkedHashMap<String, StringMatchRule> parseRules(String rules) {
        LinkedHashMap<String, StringMatchRule> m = new LinkedHashMap<String, StringMatchRule>();
        if (null != rules) {
            List<String> rulelist = BaseStringMatchRules.elementsOf(rules, " ,\t\n\r\f");
            for (String r : rulelist) {
                StringMatchRule rule = this.parseRule(r);
                TypeUtils.putIfAbsent(m, rule.pattern, rule);
            }
        }
        return m;
    }

    protected abstract StringMatchRule parseRule(String var1);

    public static class StringMatchRule {
        public final String pattern;
        public final MatchPatternInfo patternInfo;
        public final MatchPatternInfo prefix;

        public StringMatchRule(String pattern) {
            this(pattern, true);
        }

        public StringMatchRule(String pattern, boolean withPrefix) {
            if (!Strings.isNullOrEmpty((String)pattern)) {
                String px = null;
                if (withPrefix) {
                    Pattern p = Pattern.compile(BaseStringMatchRules.RULE_FMT_REGEX);
                    Matcher m = p.matcher(pattern);
                    Preconditions.checkArgument((boolean)m.matches(), (String)"INVALID pattern %s", (Object)pattern);
                    px = Strings.nullToEmpty((String)m.group(1));
                    pattern = m.group(2);
                    this.pattern = px + pattern;
                    if ("/*/".equals(px)) {
                        px = "/.*/";
                    }
                } else {
                    this.pattern = pattern;
                }
                this.patternInfo = MatchPatternInfo.of(pattern);
                this.prefix = MatchPatternInfo.of(px);
            } else {
                this.patternInfo = null;
                this.prefix = null;
                this.pattern = pattern;
            }
        }

        public StringMatchRule() {
            this(null);
        }

        public boolean nullRule() {
            return null == this.pattern || null == this.patternInfo || this.patternInfo.nullPattern();
        }

        public String keyOfRule() {
            return this.pattern;
        }

        public boolean match(StringMatchRule matchRule) {
            if (!this.nullRule() && !StringMatchRule.nullRule(matchRule)) {
                boolean matched = this.patternInfo.match(matchRule.patternInfo);
                if (!MatchPatternInfo.nullPattern(this.prefix)) {
                    if (!MatchPatternInfo.ANY.equals(this.prefix)) {
                        matched &= this.prefix.match(matchRule.prefix);
                    }
                } else {
                    matched &= MatchPatternInfo.nullPattern(matchRule.prefix);
                }
                return matched;
            }
            return false;
        }

        public boolean match(String input) {
            if (null != input) {
                StringMatchRule matchRule = StringMatchRule.create(input, null != this.prefix);
                return this.match(matchRule);
            }
            return false;
        }

        public String toString() {
            return "StringMatchRule [" + (this.pattern != null ? "pattern=" + this.pattern + ", " : "") + (this.patternInfo != null ? "patternInfo=" + this.patternInfo + ", " : "") + (this.prefix != null ? "prefix=" + this.prefix : "") + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
            result = 31 * result + (this.patternInfo == null ? 0 : this.patternInfo.hashCode());
            result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StringMatchRule other = (StringMatchRule)obj;
            if (this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern)) {
                return false;
            }
            if (this.patternInfo == null ? other.patternInfo != null : !this.patternInfo.equals(other.patternInfo)) {
                return false;
            }
            return !(this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix));
        }

        public static StringMatchRule create(String pattern, boolean withPrefix) {
            return new StringMatchRule(pattern, withPrefix);
        }

        public static StringMatchRule create(String pattern) {
            return StringMatchRule.create(pattern, true);
        }

        public static boolean nullRule(StringMatchRule rule) {
            return null == rule || rule.nullRule();
        }
    }
}

