/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.gdface.utils.EnumTransformer;

public class BaseTypeTransformer {
    private final Function sameTypeFun = new Function(){

        public Object apply(Object input) {
            return input;
        }
    };
    private final Function<Boolean, Boolean> booleanTypeFun = new Function<Boolean, Boolean>(){

        public Boolean apply(Boolean input) {
            return (boolean)((Boolean)Preconditions.checkNotNull((Object)input, (Object)"input is null"));
        }
    };
    private final Function<Character, Character> charTypeFun = new Function<Character, Character>(){

        public Character apply(Character input) {
            return Character.valueOf(((Character)Preconditions.checkNotNull((Object)input, (Object)"input is null")).charValue());
        }
    };
    private final Function<Byte, Byte> byteTypeFun = new Function<Byte, Byte>(){

        public Byte apply(Byte input) {
            return (byte)((Byte)Preconditions.checkNotNull((Object)input, (Object)"input is null"));
        }
    };
    private final Function<Short, Short> shortTypeFun = new Function<Short, Short>(){

        public Short apply(Short input) {
            return (short)((Short)Preconditions.checkNotNull((Object)input, (Object)"input is null"));
        }
    };
    private final Function<Integer, Integer> intTypeFun = new Function<Integer, Integer>(){

        public Integer apply(Integer input) {
            return (int)((Integer)Preconditions.checkNotNull((Object)input, (Object)"input is null"));
        }
    };
    private final Function<Long, Long> longTypeFun = new Function<Long, Long>(){

        public Long apply(Long input) {
            return (long)((Long)Preconditions.checkNotNull((Object)input, (Object)"input is null"));
        }
    };
    private final Function<Float, Float> floatTypeFun = new Function<Float, Float>(){

        public Float apply(Float input) {
            return Float.valueOf(((Float)Preconditions.checkNotNull((Object)input, (Object)"input is null")).floatValue());
        }
    };
    private final Function<Double, Double> doubleTypeFun = new Function<Double, Double>(){

        public Double apply(Double input) {
            Double.class.isPrimitive();
            return (double)((Double)Preconditions.checkNotNull((Object)input, (Object)"input is null"));
        }
    };
    private final Function<Void, Void> voidTypeFun = new Function<Void, Void>(){

        public Void apply(Void input) {
            return null;
        }
    };
    private final Function<byte[], ByteBuffer> byteArray2ByteBufferFun = new Function<byte[], ByteBuffer>(){

        public ByteBuffer apply(byte[] input) {
            return null == input ? null : ByteBuffer.wrap(input);
        }
    };
    private final Function<ByteBuffer, byte[]> byteBuffer2ByteArrayFun = new Function<ByteBuffer, byte[]>(){

        public byte[] apply(ByteBuffer input) {
            return BaseTypeTransformer.getBytesInBuffer(input);
        }
    };
    private final Function<Float, Double> float2DoubleFun = new Function<Float, Double>(){

        public Double apply(Float input) {
            return null == input ? null : Double.valueOf(input.doubleValue());
        }
    };
    private final Function<Double, Float> double2FloatFun = new Function<Double, Float>(){

        public Float apply(Double input) {
            return null == input ? null : Float.valueOf(input.floatValue());
        }
    };
    private final Function<java.util.Date, Long> date2LongFunction = new Function<java.util.Date, Long>(){

        public Long apply(java.util.Date input) {
            return null == input ? null : Long.valueOf(input.getTime());
        }
    };
    private final Function<Long, java.util.Date> long2DateFun = new Function<Long, java.util.Date>(){

        public java.util.Date apply(Long input) {
            return null == input ? null : new java.util.Date(input);
        }
    };
    private final Function<Long, Date> long2SqlDateFun = new Function<Long, Date>(){

        public Date apply(Long input) {
            return null == input ? null : new Date(input);
        }
    };
    private final Function<Long, Time> long2SqlTimeFun = new Function<Long, Time>(){

        public Time apply(Long input) {
            return null == input ? null : new Time(input);
        }
    };
    private final Function<URL, String> url2StringFun = new Function<URL, String>(){

        public String apply(URL input) {
            return null == input ? null : input.toString();
        }
    };
    private final Function<URI, String> uri2StringFun = new Function<URI, String>(){

        public String apply(URI input) {
            return null == input ? null : input.toString();
        }
    };
    private final Function<String, URL> string2UrlFun = new Function<String, URL>(){

        public URL apply(String input) {
            try {
                return null == input ? null : new URL(input);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private final Function<String, URI> string2UriFun = new Function<String, URI>(){

        public URI apply(String input) {
            return null == input ? null : URI.create(input);
        }
    };
    private final Function<int[], List<Integer>> intArray2List = new Function<int[], List<Integer>>(){

        public List<Integer> apply(int[] input) {
            return null == input ? null : Ints.asList((int[])input);
        }
    };
    private final Function<long[], List<Long>> longArray2List = new Function<long[], List<Long>>(){

        public List<Long> apply(long[] input) {
            return null == input ? null : Longs.asList((long[])input);
        }
    };
    private final Function<double[], List<Double>> doubleArray2List = new Function<double[], List<Double>>(){

        public List<Double> apply(double[] input) {
            return null == input ? null : Doubles.asList((double[])input);
        }
    };
    private final Function<float[], List<Double>> floatArray2List = new Function<float[], List<Double>>(){

        public List<Double> apply(float[] input) {
            return null == input ? null : Lists.transform((List)Floats.asList((float[])input), (Function)BaseTypeTransformer.this.float2DoubleFun);
        }
    };
    private final Function<short[], List<Short>> shortArray2List = new Function<short[], List<Short>>(){

        public List<Short> apply(short[] input) {
            return null == input ? null : Shorts.asList((short[])input);
        }
    };
    private final Function<boolean[], List<Boolean>> booleanArray2List = new Function<boolean[], List<Boolean>>(){

        public List<Boolean> apply(boolean[] input) {
            return null == input ? null : Booleans.asList((boolean[])input);
        }
    };
    private final Function<List<Integer>, int[]> list2intArray = new Function<List<Integer>, int[]>(){

        public int[] apply(List<Integer> input) {
            return null == input ? null : Ints.toArray(input);
        }
    };
    private final Function<List<Long>, long[]> list2longArray = new Function<List<Long>, long[]>(){

        public long[] apply(List<Long> input) {
            return null == input ? null : Longs.toArray(input);
        }
    };
    private final Function<List<Double>, double[]> list2doubleArray = new Function<List<Double>, double[]>(){

        public double[] apply(List<Double> input) {
            return null == input ? null : Doubles.toArray(input);
        }
    };
    private final Function<List<Double>, float[]> list2floatArray = new Function<List<Double>, float[]>(){

        public float[] apply(List<Double> input) {
            return null == input ? null : Floats.toArray(input);
        }
    };
    private final Function<List<Short>, short[]> list2shortArray = new Function<List<Short>, short[]>(){

        public short[] apply(List<Short> input) {
            return null == input ? null : Shorts.toArray(input);
        }
    };
    private final Function<List<Boolean>, boolean[]> list2booleanArray = new Function<List<Boolean>, boolean[]>(){

        public boolean[] apply(List<Boolean> input) {
            return null == input ? null : Booleans.toArray(input);
        }
    };
    protected final Table<Class<?>, Class<?>, Function<?, ?>> transTable = HashBasedTable.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] getBytesInBuffer(ByteBuffer buffer) {
        if (null == buffer) {
            return null;
        }
        int pos = buffer.position();
        try {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            buffer.position(pos);
        }
    }

    public BaseTypeTransformer() {
        this.transTable.put(byte[].class, ByteBuffer.class, this.byteArray2ByteBufferFun);
        this.transTable.put(ByteBuffer.class, byte[].class, this.byteBuffer2ByteArrayFun);
        this.transTable.put(Float.class, Double.class, this.float2DoubleFun);
        this.transTable.put(Double.class, Float.class, this.double2FloatFun);
        this.transTable.put(Float.TYPE, Double.TYPE, this.float2DoubleFun);
        this.transTable.put(Float.TYPE, Double.class, this.float2DoubleFun);
        this.transTable.put(Double.TYPE, Float.TYPE, this.double2FloatFun);
        this.transTable.put(Double.TYPE, Float.class, this.double2FloatFun);
        this.transTable.put(java.util.Date.class, Long.class, this.date2LongFunction);
        this.transTable.put(Date.class, Long.class, this.date2LongFunction);
        this.transTable.put(Time.class, Long.class, this.date2LongFunction);
        this.transTable.put(Long.class, java.util.Date.class, this.long2DateFun);
        this.transTable.put(Long.class, Date.class, this.long2SqlDateFun);
        this.transTable.put(Long.class, Time.class, this.long2SqlTimeFun);
        this.transTable.put(URL.class, String.class, this.url2StringFun);
        this.transTable.put(URI.class, String.class, this.uri2StringFun);
        this.transTable.put(String.class, URL.class, this.string2UrlFun);
        this.transTable.put(String.class, URI.class, this.string2UriFun);
        this.transTable.put(int[].class, List.class, this.intArray2List);
        this.transTable.put(long[].class, List.class, this.longArray2List);
        this.transTable.put(double[].class, List.class, this.doubleArray2List);
        this.transTable.put(float[].class, List.class, this.floatArray2List);
        this.transTable.put(short[].class, List.class, this.shortArray2List);
        this.transTable.put(boolean[].class, List.class, this.booleanArray2List);
        this.transTable.put(List.class, int[].class, this.list2intArray);
        this.transTable.put(List.class, long[].class, this.list2longArray);
        this.transTable.put(List.class, double[].class, this.list2doubleArray);
        this.transTable.put(List.class, float[].class, this.list2floatArray);
        this.transTable.put(List.class, short[].class, this.list2shortArray);
        this.transTable.put(List.class, boolean[].class, this.list2booleanArray);
        this.transTable.put(Boolean.class, Boolean.TYPE, this.booleanTypeFun);
        this.transTable.put(Character.class, Character.TYPE, this.charTypeFun);
        this.transTable.put(Byte.class, Byte.TYPE, this.byteTypeFun);
        this.transTable.put(Short.class, Short.TYPE, this.shortTypeFun);
        this.transTable.put(Integer.class, Integer.TYPE, this.intTypeFun);
        this.transTable.put(Long.class, Long.TYPE, this.longTypeFun);
        this.transTable.put(Float.class, Float.TYPE, this.floatTypeFun);
        this.transTable.put(Double.class, Double.TYPE, this.doubleTypeFun);
        this.transTable.put(Void.class, Void.TYPE, this.voidTypeFun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <L, R> BaseTypeTransformer setTransformer(Class<L> left, Class<R> right, Function<L, R> trans) {
        Preconditions.checkArgument((null != left && null != right && null != trans ? 1 : 0) != 0, (Object)"left, right, trans must not be null");
        Table<Class<?>, Class<?>, Function<?, ?>> table = this.transTable;
        synchronized (table) {
            this.transTable.put(left, right, trans);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <L, R> Function<L, R> getTransformer(Class<L> left, Class<R> right) {
        Preconditions.checkArgument((null != left && null != right ? 1 : 0) != 0, (Object)"left, right must not be null");
        if (right.isAssignableFrom(left)) {
            return this.sameTypeFun;
        }
        EnumTransformer<L, R> result = (EnumTransformer<L, R>)this.transTable.get(left, right);
        if (null == result && Enum.class.isAssignableFrom(left) && Enum.class.isAssignableFrom(right)) {
            Table<Class<?>, Class<?>, Function<?, ?>> table = this.transTable;
            synchronized (table) {
                result = (Function)this.transTable.get(left, right);
                if (null == result) {
                    result = new EnumTransformer<L, R>(left, right);
                    this.setTransformer(left, right, result);
                }
            }
        }
        return result;
    }

    public <L, R> Function<L, R> getTransformerChecked(Class<L> left, Class<R> right) {
        return (Function)Preconditions.checkNotNull(this.getTransformer(left, right), (String)"not found transformer for %s to %s", left, right);
    }

    public <L, R> R to(L value, Class<L> left, Class<R> right) {
        if (null == value) {
            return null;
        }
        Preconditions.checkArgument((null != right ? 1 : 0) != 0, (Object)"right is null");
        if (right.isInstance(value)) {
            return (R)value;
        }
        return (R)this.getTransformerChecked(left, right).apply(value);
    }

    public <L, R> List<R> to(List<L> input, Class<L> left, Class<R> right) {
        return null == input ? null : Lists.transform(input, this.getTransformerChecked(left, right));
    }

    public <L, R> Set<R> to(Set<L> input, Class<L> left, Class<R> right) {
        return null == input ? null : Sets.newHashSet((Iterable)Iterables.transform(input, this.getTransformerChecked(left, right)));
    }

    public <L, R> List<R> to(L[] input, Class<L> left, Class<R> right) {
        if (null == input) {
            return null;
        }
        return this.to(Arrays.asList(input), left, right);
    }

    public List<Integer> to(int[] input, Class<Integer> left, Class<Integer> right) {
        return (List)this.intArray2List.apply((Object)input);
    }

    public List<Long> to(long[] input, Class<Long> left, Class<Long> right) {
        return (List)this.longArray2List.apply((Object)input);
    }

    public List<Double> to(double[] input, Class<Double> left, Class<Double> right) {
        return (List)this.doubleArray2List.apply((Object)input);
    }

    public List<Double> to(float[] input, Class<Float> left, Class<Double> right) {
        return (List)this.floatArray2List.apply((Object)input);
    }

    public List<Short> to(short[] input, Class<Short> left, Class<Short> right) {
        return (List)this.shortArray2List.apply((Object)input);
    }

    public List<Boolean> to(boolean[] input, Class<Boolean> left, Class<Boolean> right) {
        return (List)this.booleanArray2List.apply((Object)input);
    }

    public <L, R> R[] toArray(List<L> input, Class<L> left, Class<R> right) {
        if (null == input) {
            return null;
        }
        List<R> r = this.to(input, left, right);
        return r.toArray((Object[])Array.newInstance(right, r.size()));
    }

    public int[] tointArray(List<Integer> input, Class<Integer> left, Class<Integer> right) {
        return (int[])this.list2intArray.apply(input);
    }

    public long[] tolongArray(List<Long> input, Class<Long> left, Class<Long> right) {
        return (long[])this.list2longArray.apply(input);
    }

    public double[] todoubleArray(List<Double> input, Class<Double> left, Class<Double> right) {
        return (double[])this.list2doubleArray.apply(input);
    }

    public float[] tofloatArray(List<Double> input, Class<Double> left, Class<Float> right) {
        return (float[])this.list2floatArray.apply(input);
    }

    public short[] toshortArray(List<Short> input, Class<Short> left, Class<Short> right) {
        return (short[])this.list2shortArray.apply(input);
    }

    public boolean[] tobooleanArray(List<Boolean> input, Class<Boolean> left, Class<Boolean> right) {
        return (boolean[])this.list2booleanArray.apply(input);
    }

    public <K1, V1, K2, V2> Map<K2, V2> to(Map<K1, V1> input, Class<K1> k1, Class<V1> v1, Class<K2> k2, Class<V2> v2) {
        Preconditions.checkArgument((null != k1 && null != v1 && null != k2 && null != v2 ? 1 : 0) != 0, (Object)"k1,v1,k2,v2 must not be null");
        if (k1 == k2) {
            if (v1 == v2) {
                return input;
            }
            return Maps.transformValues(input, this.getTransformerChecked(v1, v2));
        }
        Map<K2, V1> k2v1 = BaseTypeTransformer.transform(input, this.getTransformerChecked(k1, k2));
        if (v1 == v2) {
            return k2v1;
        }
        return Maps.transformValues(k2v1, this.getTransformerChecked(v1, v2));
    }

    public <L, R> R cast(Object value, Type left, Type right) {
        TypeToken leftToken = TypeToken.of((Type)((Type)Preconditions.checkNotNull((Object)left)));
        TypeToken rightToken = TypeToken.of((Type)((Type)Preconditions.checkNotNull((Object)right)));
        if (null == value) {
            Preconditions.checkArgument((!(right instanceof Class) || !((Class)right).isPrimitive() ? 1 : 0) != 0, (String)"cant cast null to primitive type %s", (Object)right);
            return null;
        }
        if (left instanceof Class && right instanceof Class) {
            return this.to(value, (Class)left, (Class)right);
        }
        if (List.class.isAssignableFrom(leftToken.getRawType()) && null != rightToken.getComponentType()) {
            Class componentType = rightToken.getComponentType().getRawType();
            if (componentType == Integer.TYPE) {
                return (R)this.tointArray((List)value, Integer.class, Integer.TYPE);
            }
            if (componentType == Long.TYPE) {
                return (R)this.tolongArray((List)value, Long.class, Long.TYPE);
            }
            if (componentType == Double.TYPE) {
                return (R)this.todoubleArray((List)value, Double.class, Double.TYPE);
            }
            if (componentType == Float.TYPE) {
                return (R)this.tofloatArray((List)value, Double.class, Float.TYPE);
            }
            if (componentType == Short.TYPE) {
                return (R)this.toshortArray((List)value, Short.class, Short.TYPE);
            }
            if (componentType == Boolean.TYPE) {
                return (R)this.tobooleanArray((List)value, Boolean.class, Boolean.TYPE);
            }
            Type elementType = ((ParameterizedType)left).getActualTypeArguments()[0];
            if (elementType instanceof Class) {
                return (R)this.toArray((List)value, (Class)elementType, componentType);
            }
            throw new UnsupportedOperationException(String.format("unsupported cast %s to %s", left, right));
        }
        if (List.class.isAssignableFrom(leftToken.getRawType()) && List.class == rightToken.getRawType()) {
            Preconditions.checkArgument((boolean)(value instanceof List));
            Type leftElementType = ((ParameterizedType)left).getActualTypeArguments()[0];
            Type rightElementType = ((ParameterizedType)right).getActualTypeArguments()[0];
            if (leftElementType instanceof Class && rightElementType instanceof Class) {
                return (R)this.to((List)value, (Class)leftElementType, (Class)rightElementType);
            }
            throw new UnsupportedOperationException(String.format("unsupported cast %s to %s", left, right));
        }
        if (Set.class.isAssignableFrom(leftToken.getRawType()) && Set.class == rightToken.getRawType()) {
            Preconditions.checkArgument((boolean)(value instanceof Set));
            Type leftElementType = ((ParameterizedType)left).getActualTypeArguments()[0];
            Type rightElementType = ((ParameterizedType)right).getActualTypeArguments()[0];
            if (leftElementType instanceof Class && rightElementType instanceof Class) {
                return (R)this.to((Set)value, (Class)leftElementType, (Class)rightElementType);
            }
            throw new UnsupportedOperationException(String.format("unsupported cast %s to %s", left, right));
        }
        if (Map.class.isAssignableFrom(leftToken.getRawType()) && Map.class == rightToken.getRawType()) {
            Type k1Type = ((ParameterizedType)left).getActualTypeArguments()[0];
            Type v1Type = ((ParameterizedType)left).getActualTypeArguments()[1];
            Type k2Type = ((ParameterizedType)right).getActualTypeArguments()[0];
            Type v2Type = ((ParameterizedType)right).getActualTypeArguments()[1];
            if (k1Type instanceof Class && v1Type instanceof Class && k2Type instanceof Class && v2Type instanceof Class) {
                return (R)this.to((Map)value, (Class)k1Type, (Class)v1Type, (Class)k2Type, (Class)v2Type);
            }
            throw new UnsupportedOperationException(String.format("unsupported cast %s to %s", left, right));
        }
        if (leftToken.isArray() && List.class == rightToken.getRawType()) {
            Preconditions.checkArgument((boolean)value.getClass().isArray());
            Type componentType = leftToken.getComponentType().getType();
            if (componentType == Integer.TYPE) {
                return (R)this.to((int[])value, Integer.TYPE, Integer.class);
            }
            if (componentType == Long.TYPE) {
                return (R)this.to((long[])value, Long.TYPE, Long.class);
            }
            if (componentType == Double.TYPE) {
                return (R)this.to((double[])value, Double.TYPE, Double.class);
            }
            if (componentType == Float.TYPE) {
                return (R)this.to((float[])value, Float.TYPE, Double.class);
            }
            if (componentType == Short.TYPE) {
                return (R)this.to((short[])value, Short.TYPE, Short.class);
            }
            if (componentType == Boolean.TYPE) {
                return (R)this.to((boolean[])value, Boolean.TYPE, Boolean.class);
            }
            Type rightElementType = ((ParameterizedType)right).getActualTypeArguments()[0];
            if (leftToken.getComponentType().getType() instanceof Class && rightElementType instanceof Class) {
                return (R)this.to((Object[])value, (Class)componentType, (Class)rightElementType);
            }
            throw new UnsupportedOperationException(String.format("unsupported cast %s to %s", left, right));
        }
        throw new UnsupportedOperationException(String.format("unsupported cast %s to %s", left, right));
    }

    public static final <K1, K2, V> Map<K2, V> transform(Map<K1, V> fromMap, final Function<K1, K2> transformer) {
        Preconditions.checkNotNull(fromMap, (Object)"fromMap is null");
        Preconditions.checkNotNull(transformer, (Object)"transformer is null");
        ImmutableMap k2Entry = Maps.uniqueIndex(fromMap.entrySet(), (Function)new Function<Map.Entry<K1, V>, K2>(){

            public K2 apply(Map.Entry<K1, V> input) {
                return transformer.apply(input.getKey());
            }
        });
        Map k2V = Maps.transformEntries((Map)k2Entry, (Maps.EntryTransformer)new Maps.EntryTransformer<K2, Map.Entry<K1, V>, V>(){

            public V transformEntry(K2 key, Map.Entry<K1, V> value) {
                return value.getValue();
            }
        });
        return k2V;
    }
}

