/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.common.base.Throwables;
import com.google.common.primitives.Primitives;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.gdface.utils.SerializationUtils;

public class DeepCloneUtils {
    public static <T> T cloneFields(T input, int ifVolatile) {
        if (DeepCloneUtils.noClone(input)) {
            return input;
        }
        for (Class<?> clazz = input.getClass(); null != clazz && !Object.class.equals(clazz); clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                try {
                    if ((field.getModifiers() & 0x18) != 0 || DeepCloneUtils.noClone(field.getType())) continue;
                    field.setAccessible(true);
                    if (!Modifier.isVolatile(field.getModifiers())) {
                        field.set(input, DeepCloneUtils.deepClone(field.get(input)));
                        continue;
                    }
                    if (1 == ifVolatile) {
                        field.set(input, null);
                        continue;
                    }
                    if (2 != ifVolatile) continue;
                    field.set(input, DeepCloneUtils.deepClone(field.get(input)));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
        return input;
    }

    public static <T> T cloneFields(T input) {
        return DeepCloneUtils.cloneFields(input, 2);
    }

    public static <T> T deepClone(T input) {
        Object cloned;
        if (DeepCloneUtils.noClone(input)) {
            return input;
        }
        if (input instanceof Collection && input != (cloned = DeepCloneUtils.tryConstructContainer(input, Collection.class))) {
            return cloned;
        }
        if (input instanceof Map && input != (cloned = DeepCloneUtils.tryConstructContainer(input, Map.class))) {
            return cloned;
        }
        if (input instanceof Cloneable) {
            if (input.getClass().isArray()) {
                Class<?> componentType = input.getClass().getComponentType();
                int length = Array.getLength(input);
                cloned = Array.newInstance(componentType, length);
                System.arraycopy(input, 0, cloned, 0, length);
                if (!DeepCloneUtils.noClone(componentType)) {
                    int end_i = Array.getLength(cloned);
                    for (int i = 0; i < end_i; ++i) {
                        Array.set(cloned, i, DeepCloneUtils.deepClone(Array.get(cloned, i)));
                    }
                }
            } else {
                cloned = DeepCloneUtils.callClone(input);
            }
            return cloned;
        }
        if (input instanceof Serializable) {
            return (T)SerializationUtils.clone((Serializable)input);
        }
        throw new IllegalArgumentException("NO SUPPORT CLONE " + input.getClass());
    }

    private static <T> T callClone(T input) {
        try {
            return (T)input.getClass().getMethod("clone", new Class[0]).invoke(input, new Object[0]);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static boolean noClone(Object object) {
        if (null == object) {
            return true;
        }
        return DeepCloneUtils.noClone(object.getClass());
    }

    private static boolean noClone(Class<?> clazz) {
        if (Primitives.unwrap(clazz).isPrimitive()) {
            return true;
        }
        return String.class.equals(clazz);
    }

    private static <T> T tryConstructContainer(T input, Class<?> targetType) {
        if (targetType.isInstance(input)) {
            try {
                if (input instanceof Map || input instanceof Collection) {
                    Object output = input.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (output instanceof Map) {
                        Set entrySet = ((Map)input).entrySet();
                        for (Map.Entry entry : entrySet) {
                            ((Map)output).put(entry.getKey(), DeepCloneUtils.deepClone(entry.getValue()));
                        }
                        return (T)output;
                    }
                    if (output instanceof Collection) {
                        for (Object element : (Collection)input) {
                            ((Collection)output).add(DeepCloneUtils.deepClone(element));
                        }
                        return (T)output;
                    }
                }
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return input;
    }
}

