/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DefaultExecutorProvider {
    private static final int CACHE_COREPOOLSIZE = Runtime.getRuntime().availableProcessors();
    private static final int CACHE_MAXIMUMPOOLSIZE = Runtime.getRuntime().availableProcessors() * 4;
    private static final long CACHE_KEEPALIVETIME = 60L;
    private static final int CACHE_QUEUECAPACITY = 1024;
    private static final String CACHE_NAMEFORMAT = "cached-pool-%d";
    private static final int CACHE_TIMER_COREPOOLSIZE = 1;
    private static final String TIMER_NAMEFORMAT = "timer-pool-%d";
    protected final ExecutorService globalExecutor = this.createExitingCachedPool();
    protected final ScheduledExecutorService timerExecutor = this.createExitingScheduledPool();

    protected static final ExecutorService createCachedPool(Integer corePoolSize, Integer maximumPoolSize, Long keepAliveTime, Integer queueCapacity, String nameFormat) {
        ExecutorService executor = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)new ThreadPoolExecutor((int)((Integer)MoreObjects.firstNonNull((Object)corePoolSize, (Object)CACHE_COREPOOLSIZE)), (int)((Integer)MoreObjects.firstNonNull((Object)maximumPoolSize, (Object)CACHE_MAXIMUMPOOLSIZE)), (long)((Long)MoreObjects.firstNonNull((Object)keepAliveTime, (Object)60L)), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>((Integer)MoreObjects.firstNonNull((Object)queueCapacity, (Object)1024)), new ThreadFactoryBuilder().setNameFormat((String)MoreObjects.firstNonNull((Object)nameFormat, (Object)CACHE_NAMEFORMAT)).build()));
        return executor;
    }

    protected static final ScheduledExecutorService createScheduledPool(Integer corePoolSize, String nameFormat) {
        ScheduledExecutorService timerExecutor = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor((int)((Integer)MoreObjects.firstNonNull((Object)corePoolSize, (Object)1)), new ThreadFactoryBuilder().setNameFormat((String)MoreObjects.firstNonNull((Object)nameFormat, (Object)TIMER_NAMEFORMAT)).build()));
        return timerExecutor;
    }

    protected ExecutorService createExitingCachedPool() {
        return DefaultExecutorProvider.createCachedPool(null, null, null, null, null);
    }

    protected ScheduledExecutorService createExitingScheduledPool() {
        return DefaultExecutorProvider.createScheduledPool(null, null);
    }

    protected DefaultExecutorProvider() {
    }

    public static ExecutorService getGlobalExceutor() {
        return Singleton.INSTANCE.globalExecutor;
    }

    public static ScheduledExecutorService getTimerExecutor() {
        return Singleton.INSTANCE.timerExecutor;
    }

    private static class Singleton {
        private static final DefaultExecutorProvider INSTANCE = new DefaultExecutorProvider();

        private Singleton() {
        }
    }
}

