/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;

public class FunctionCached<K, V>
implements Function<K, V> {
    private final LoadingCache<K, Object> cache;
    private final Function<K, V> getterFunction;
    private final V defaultValue;

    public FunctionCached(final Function<K, V> getterFunction, V defaultValue, CacheBuilder<Object, Object> cacheBuilder) {
        this.getterFunction = (Function)Preconditions.checkNotNull(getterFunction, (Object)"getterFunction is null");
        Preconditions.checkArgument((!(getterFunction instanceof FunctionCached) ? 1 : 0) != 0, (String)"getterFunction must not be instance of %s", (Object)this.getClass().getName());
        this.defaultValue = defaultValue;
        if (null == cacheBuilder) {
            cacheBuilder = CacheBuilder.newBuilder();
        }
        this.cache = cacheBuilder.build(new CacheLoader<K, Object>(){

            public Object load(K key) {
                try {
                    return getterFunction.apply(key);
                }
                catch (Exception e) {
                    return e;
                }
            }
        });
    }

    public FunctionCached(Function<K, V> getterFunction, V defaultValue) {
        this(getterFunction, defaultValue, null);
    }

    public FunctionCached(Function<K, V> getterFunction) {
        this(getterFunction, null);
    }

    public V getUncached(K key) {
        return (V)(null == key ? this.defaultValue : this.getterFunction.apply(key));
    }

    public V get(K key) {
        if (null != key) {
            Object value = this.cache.getUnchecked(key);
            if (value instanceof Exception) {
                Throwables.throwIfUnchecked((Throwable)((Exception)value));
                throw new RuntimeException((Exception)value);
            }
            return (V)value;
        }
        return this.defaultValue;
    }

    public V apply(K input) {
        return this.get(input);
    }

    public static <K, V> FunctionCached<K, V> of(Function<K, V> getterFunction, V defaultValue, CacheBuilder<Object, Object> cacheBuilder) {
        if (getterFunction instanceof FunctionCached) {
            return (FunctionCached)getterFunction;
        }
        return new FunctionCached<K, V>(getterFunction, defaultValue, cacheBuilder);
    }

    public static <K, V> FunctionCached<K, V> of(Function<K, V> getterFunction, V defaultValue) {
        return FunctionCached.of(getterFunction, defaultValue, null);
    }

    public static <K, V> FunctionCached<K, V> of(Function<K, V> getterFunction) {
        return FunctionCached.of(getterFunction, null);
    }
}

