/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.net.HostAndPort;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import jcifs.Address;
import jcifs.CIFSException;
import jcifs.NameServiceClient;
import jcifs.NetbiosAddress;
import jcifs.context.SingletonContext;
import jcifs.netbios.NbtAddress;
import jcifs.netbios.UniAddress;
import net.gdface.utils.IPAddressUtil;

public class JcifsUtil {
    private static final NameServiceClient nsc;
    private static final String REG_IPV4 = "^((?:(?:25[0-5]|2[0-4]\\d|[01]?\\d?\\d)\\.){3}(?:25[0-5]|2[0-4]\\d|[01]?\\d?\\d))$";
    private static final LoadingCache<String, String> IP_CACHE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String firstValidAddress(Address ... addrs) {
        AtomicReference<String> addr = new AtomicReference<String>();
        List<Thread> threads = Collections.synchronizedList(new ArrayList(addrs.length));
        for (Address address : addrs) {
            if (!IPAddressUtil.isIPv4LiteralAddress(address.getHostAddress())) continue;
            new CheckHostStatusThread(address, addr, threads).start();
        }
        AtomicReference<String> atomicReference = addr;
        synchronized (atomicReference) {
            while (addr.get() == null && !threads.isEmpty()) {
                try {
                    addr.wait(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
        }
        return (String)addr.get();
    }

    private static String firstValidAddressChecked(Address ... addrs) throws UnknownHostException {
        String validAddress = JcifsUtil.firstValidAddress(addrs);
        if (validAddress == null) {
            throw new UnknownHostException("NOT FOUND REACHABLE HOST ");
        }
        return validAddress;
    }

    public static String addressOfLanhost(String host) throws UnknownHostException {
        if (host == null || host.matches(REG_IPV4)) {
            return host;
        }
        NetbiosAddress[] addrs = nsc.getNbtAllByName(host, 0, null, null);
        return JcifsUtil.firstValidAddressChecked((Address[])addrs);
    }

    public static String hostAddressOf(String host) throws UnknownHostException {
        if (host == null || host.matches(REG_IPV4)) {
            return host;
        }
        Address[] addrs = nsc.getAllByName(host, true);
        String validAddress = JcifsUtil.firstValidAddress(addrs);
        if (validAddress == null) {
            validAddress = JcifsUtil.addressOfLanhost(host);
        }
        return validAddress;
    }

    public static String getAddressIfPossible(String host) {
        try {
            return JcifsUtil.hostAddressOf(host);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static boolean isResolvableHost(String host) {
        return JcifsUtil.getAddressIfPossible(host) != null;
    }

    public static URI changeHostIfLanhost(URI input) {
        if (input != null && input.getHost() != null && !input.getHost().matches(REG_IPV4)) {
            String host = (String)IP_CACHE.getUnchecked((Object)input.getHost());
            URI u2 = JcifsUtil.changeHostUnchecked(input, host);
            return u2;
        }
        return input;
    }

    public static String changeHostIfLanhost(String input) {
        if (input != null) {
            try {
                URI uri = new URI(input);
                if (uri.getHost() != null) {
                    return JcifsUtil.changeHostIfLanhost(uri).toString();
                }
            }
            catch (URISyntaxException uri) {
                // empty catch block
            }
            try {
                HostAndPort hostAndPort = HostAndPort.fromString((String)input);
                String changed = JcifsUtil.changeHostIfLanhost(URI.create("//" + hostAndPort.toString())).toString();
                return changed.substring(2);
            }
            catch (Exception e) {
                return JcifsUtil.changeHostIfLanhost(URI.create(input)).toString();
            }
        }
        return input;
    }

    public static URL changeHostIfLanhost(URL input) {
        if (input != null) {
            try {
                return JcifsUtil.changeHostIfLanhost(input.toURI()).toURL();
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return input;
    }

    private static URI changeHost(URI bindAddr, String host) throws URISyntaxException {
        if (Objects.equal((Object)bindAddr.getHost(), (Object)host)) {
            return bindAddr;
        }
        return new URI(bindAddr.getScheme(), bindAddr.getUserInfo(), host, bindAddr.getPort(), bindAddr.getPath(), bindAddr.getQuery(), bindAddr.getFragment());
    }

    private static URI changeHostUnchecked(URI bindAddr, String host) {
        try {
            return JcifsUtil.changeHost(bindAddr, host);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Properties props = new Properties();
        props.setProperty("jcifs.netbios.retryTimeout", "2000");
        try {
            SingletonContext.init((Properties)props);
        }
        catch (CIFSException e) {
            e.printStackTrace();
        }
        nsc = SingletonContext.getInstance().getNameServiceClient();
        IP_CACHE = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String host) throws Exception {
                try {
                    String address = JcifsUtil.hostAddressOf(host);
                    return IPAddressUtil.internalIp(address) ? address : host;
                }
                catch (UnknownHostException e) {
                    return host;
                }
            }
        });
    }

    static class CheckHostStatusThread
    extends Thread {
        final Address address;
        final AtomicReference<String> output;
        private final List<Thread> threads;

        public CheckHostStatusThread(Address address, AtomicReference<String> output, List<Thread> threads) {
            this.address = address;
            this.output = output;
            this.threads = threads;
            this.setName(this.getClass().getSimpleName() + "-thread");
            this.threads.add(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                String ip = this.address.getHostAddress();
                if (this.address instanceof NetbiosAddress) {
                    nsc.getNodeStatus((NetbiosAddress)this.address.unwrap(NbtAddress.class));
                } else {
                    if (!(this.address instanceof UniAddress)) throw new IllegalArgumentException("INVALID ADDRESS Type " + this.address.getClass().getName());
                    Object obj = ((UniAddress)this.address).getAddress();
                    if (obj instanceof NetbiosAddress) {
                        nsc.getNodeStatus((NetbiosAddress)obj);
                    } else {
                        if (!(obj instanceof InetAddress)) throw new IllegalArgumentException("INVALID ADDRESS Type " + this.address.getClass().getName());
                        nsc.getByName(ip);
                    }
                }
                if (!this.output.compareAndSet(null, ip)) return;
                AtomicReference<String> atomicReference = this.output;
                synchronized (atomicReference) {
                    this.output.notifyAll();
                    return;
                }
            }
            catch (UnknownHostException unknownHostException) {
                return;
            }
            finally {
                this.threads.remove(this);
            }
        }
    }
}

