/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import net.gdface.utils.MatchType;

public class MatchPatternInfo {
    public static final MatchPatternInfo ANY = MatchPatternInfo.of("*");
    private String pattern;
    private MatchType matchType;

    public MatchPatternInfo() {
    }

    public MatchPatternInfo(String pattern, MatchType matchType) {
        this.pattern = pattern;
        this.matchType = matchType;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public void setMatchType(MatchType matchType) {
        this.matchType = matchType;
    }

    public boolean nullPattern() {
        return null == this.pattern || null == this.matchType;
    }

    public boolean match(MatchPatternInfo inputPatternInfo) {
        if (!this.nullPattern() && !MatchPatternInfo.nullPattern(inputPatternInfo)) {
            return this.matchType.match(inputPatternInfo.pattern, this.pattern);
        }
        return false;
    }

    public boolean match(String input) {
        if (!this.nullPattern() && !Strings.isNullOrEmpty((String)input)) {
            return this.matchType.match(input, this.pattern);
        }
        return false;
    }

    public boolean isDefaultMatch() {
        return MatchType.DEFAULT.equals((Object)this.matchType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.matchType == null ? 0 : this.matchType.hashCode());
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MatchPatternInfo other = (MatchPatternInfo)obj;
        if (this.matchType != other.matchType) {
            return false;
        }
        return !(this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern));
    }

    public String toString() {
        return "MatchPatternInfo [" + (this.pattern != null ? "pattern=" + this.pattern + ", " : "") + (this.matchType != null ? "matchType=" + (Object)((Object)this.matchType) : "") + "]";
    }

    public static MatchPatternInfo of(String pattern) {
        if (Strings.isNullOrEmpty((String)pattern)) {
            return null;
        }
        if (pattern.matches("[\\w/]+")) {
            return new MatchPatternInfo(pattern, MatchType.DEFAULT);
        }
        if (pattern.matches("[\\w/]+\\*")) {
            return new MatchPatternInfo(pattern.replace("*", ""), MatchType.LEFT);
        }
        if (pattern.matches("\\*[\\w/]+")) {
            return new MatchPatternInfo(pattern.replace("*", ""), MatchType.RIGHT);
        }
        if (pattern.matches("\\*[\\w/]+\\*")) {
            return new MatchPatternInfo(pattern.replace("*", ""), MatchType.INCLUDE);
        }
        if (pattern.matches("\\*")) {
            return new MatchPatternInfo(".*", MatchType.REGEX);
        }
        return new MatchPatternInfo(pattern, MatchType.REGEX);
    }

    public static MatchPatternInfo of(String pattern, boolean lenient) {
        if (!lenient) {
            return MatchPatternInfo.of(pattern);
        }
        return MatchPatternInfo.of(pattern, ":\\-/@#%");
    }

    public static MatchPatternInfo of(String pattern, char ... lenientChars) {
        if (null == lenientChars) {
            lenientChars = new char[]{};
        }
        return MatchPatternInfo.of(pattern, new String(lenientChars));
    }

    public static MatchPatternInfo of(String pattern, String lenientChars) {
        if (Strings.isNullOrEmpty((String)pattern)) {
            return null;
        }
        String plainCharsRegex = "[\\w" + (String)MoreObjects.firstNonNull((Object)lenientChars, (Object)"") + "]+";
        if (pattern.matches(plainCharsRegex)) {
            return new MatchPatternInfo(pattern, MatchType.DEFAULT);
        }
        if (pattern.matches(plainCharsRegex + "\\*")) {
            return new MatchPatternInfo(pattern.replace("*", ""), MatchType.LEFT);
        }
        if (pattern.matches("\\*" + plainCharsRegex)) {
            return new MatchPatternInfo(pattern.replace("*", ""), MatchType.RIGHT);
        }
        if (pattern.matches("\\*" + plainCharsRegex + "\\*")) {
            return new MatchPatternInfo(pattern.replace("*", ""), MatchType.INCLUDE);
        }
        if (pattern.matches("\\*")) {
            return new MatchPatternInfo(".*", MatchType.REGEX);
        }
        return new MatchPatternInfo(pattern, MatchType.REGEX);
    }

    public static boolean nullPattern(MatchPatternInfo patternInfo) {
        return null == patternInfo || patternInfo.nullPattern();
    }
}

