/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.gdface.utils.TypeUtils;

public class MethodDecorator {
    protected final Method method;
    protected final String[] parameterNames;
    protected final Map<String, Parameter> paramMap;
    protected final Parameter[] parameters;
    protected final String docSignature;
    private static final int LANGUAGE_MODIFIERS = 1343;

    public MethodDecorator(Method method) {
        this(method, null);
    }

    public MethodDecorator(Method method, String[] parameterNames) {
        Class<?>[] types = ((Method)Preconditions.checkNotNull((Object)method, (Object)"method is null")).getParameterTypes();
        if (null != parameterNames && parameterNames.length != types.length) {
            throw new IllegalArgumentException("parameterNames length not equals actually parameter number");
        }
        this.method = method;
        if (null == parameterNames) {
            parameterNames = new String[types.length];
            for (int i = 0; i < parameterNames.length; ++i) {
                parameterNames[i] = String.format("arg%d", i);
            }
        }
        this.parameterNames = parameterNames;
        this.parameters = this.createParameters();
        this.paramMap = this.createParamMap(this.parameters);
        this.docSignature = this.getDocSignature(true);
    }

    private Parameter[] createParameters() {
        Parameter[] parameters = new Parameter[this.parameterNames.length];
        Annotation[][] parameterAnnotations = this.getParameterAnnotations();
        Class<?>[] parameterTypes = this.getParameterTypes();
        Type[] genericParameterTypes = this.getGenericParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = new Parameter(this.parameterNames[i], parameterTypes[i], genericParameterTypes[i], this.getParameterAnnotationMap(parameterAnnotations[i]));
        }
        return parameters;
    }

    private final Map<String, Parameter> createParamMap(Parameter[] parameters) {
        HashMap<String, Parameter> map = new HashMap<String, Parameter>(parameters.length);
        for (Parameter p : parameters) {
            map.put(p.name, p);
        }
        return map;
    }

    private Map<Class<? extends Annotation>, Annotation> getParameterAnnotationMap(Annotation[] parameterAnnotations) {
        HashMap<Class<? extends Annotation>, Annotation> map = new HashMap<Class<? extends Annotation>, Annotation>(parameterAnnotations.length);
        for (Annotation annotation : parameterAnnotations) {
            map.put(annotation.annotationType(), annotation);
        }
        return map;
    }

    public void setAccessible(boolean flag) throws SecurityException {
        this.method.setAccessible(flag);
    }

    public boolean isAccessible() {
        return this.method.isAccessible();
    }

    public Class<?> getDeclaringClass() {
        return this.method.getDeclaringClass();
    }

    public String getName() {
        return this.method.getName();
    }

    public int getModifiers() {
        return this.method.getModifiers();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.method.isAnnotationPresent(annotationClass);
    }

    public TypeVariable<Method>[] getTypeParameters() {
        return this.method.getTypeParameters();
    }

    public Annotation[] getAnnotations() {
        return this.method.getAnnotations();
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    public Class<?>[] getParameterTypes() {
        return this.method.getParameterTypes();
    }

    public Type[] getGenericParameterTypes() {
        return this.method.getGenericParameterTypes();
    }

    public Class<?>[] getExceptionTypes() {
        return this.method.getExceptionTypes();
    }

    public Type[] getGenericExceptionTypes() {
        return this.method.getGenericExceptionTypes();
    }

    public boolean equals(Object obj) {
        return this.method.equals(obj);
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public Object invoke(Object obj, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.method.invoke(obj, args);
    }

    public boolean isBridge() {
        return this.method.isBridge();
    }

    public boolean isVarArgs() {
        return this.method.isVarArgs();
    }

    public boolean isSynthetic() {
        return this.method.isSynthetic();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.method.getAnnotation(annotationClass);
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.method.getDeclaredAnnotations();
    }

    public Object getDefaultValue() {
        return this.method.getDefaultValue();
    }

    public Annotation[][] getParameterAnnotations() {
        return this.method.getParameterAnnotations();
    }

    public Parameter getParameter(String name) {
        return this.paramMap.get(name);
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public String toGenericString() {
        return this.toGenericString(false);
    }

    public String toGenericString(boolean fullClassName) {
        try {
            TypeVariable<Method>[] typeparms;
            StringBuilder sb = new StringBuilder();
            int mod = this.getModifiers() & 0x53F;
            if (mod != 0) {
                sb.append(Modifier.toString(mod) + " ");
            }
            if ((typeparms = this.getTypeParameters()).length > 0) {
                boolean first = true;
                sb.append("<");
                for (TypeVariable<Method> typeparm : typeparms) {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(TypeUtils.getTypeName(typeparm, fullClassName));
                    first = false;
                }
                sb.append("> ");
            }
            Type genRetType = this.getGenericReturnType();
            sb.append(TypeUtils.getTypeName(genRetType, fullClassName) + " ");
            if (fullClassName) {
                sb.append(TypeUtils.getTypeName(this.getDeclaringClass(), fullClassName) + ".");
            }
            sb.append(this.getName() + "(");
            Type[] params = this.getGenericParameterTypes();
            for (int j = 0; j < this.parameterNames.length; ++j) {
                sb.append(TypeUtils.getTypeName(params[j], fullClassName) + " ");
                sb.append(this.parameterNames[j]);
                if (j >= this.parameterNames.length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            Type[] exceptions = this.getGenericExceptionTypes();
            if (exceptions.length > 0) {
                sb.append(" throws ");
                for (int k = 0; k < exceptions.length; ++k) {
                    sb.append(TypeUtils.getTypeName(exceptions[k], fullClassName));
                    if (k >= exceptions.length - 1) continue;
                    sb.append(",");
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean fullClassName) {
        try {
            StringBuffer sb = new StringBuffer();
            int mod = this.getModifiers() & 0x53F;
            if (mod != 0) {
                sb.append(Modifier.toString(mod) + " ");
            }
            sb.append(TypeUtils.getTypeName(this.getReturnType(), fullClassName) + " ");
            if (fullClassName) {
                sb.append(TypeUtils.getTypeName(this.getDeclaringClass(), fullClassName) + ".");
            }
            sb.append(this.getName() + "(");
            Class<?>[] params = this.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                sb.append(TypeUtils.getTypeName(params[j], fullClassName) + " ");
                sb.append(this.parameterNames[j]);
                if (j >= this.parameterNames.length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            Class[] exceptions = (Class[])this.getGenericExceptionTypes();
            if (exceptions.length > 0) {
                sb.append(" throws ");
                for (int k = 0; k < exceptions.length; ++k) {
                    sb.append(exceptions[k].getName());
                    if (k >= exceptions.length - 1) continue;
                    sb.append(",");
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public final String getDocSignature(boolean fn) {
        return TypeUtils.getDocSignature(this.method, fn);
    }

    public String getDocSignature(Map<String, Class<?>> importedList) {
        return TypeUtils.getDocSignature(this.method, importedList);
    }

    public Set<Type> getGenericExceptionTypeSet() {
        return new HashSet<Type>(Arrays.asList(this.getGenericExceptionTypes()));
    }

    public final String getDocSignature() {
        return this.docSignature;
    }

    public final String getSignature() {
        return TypeUtils.getSignature(this.method);
    }

    public Method delegate() {
        return this.method;
    }

    public class Parameter {
        public final Class<?> type;
        public final String name;
        public final Type genericType;
        private final Map<Class<? extends Annotation>, Annotation> annotation;

        private Parameter(String name, Class<?> type, Type genericType, Map<Class<? extends Annotation>, Annotation> annotation) {
            this.name = name;
            this.type = type;
            this.genericType = genericType;
            this.annotation = annotation;
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return (T)this.annotation.get(Preconditions.checkNotNull(annotationClass, (Object)"annotationClass is null"));
        }

        public Collection<Annotation> getAnnotations() {
            return this.annotation.values();
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Type getGenericType() {
            return this.genericType;
        }
    }
}

