/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Bytes;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class NetworkUtil {
    public static final String DEFAULT_HOST = "localhost";
    private static byte[][] invalidMacs = new byte[][]{{0, 5, 105}, {0, 28, 20}, {0, 12, 41}, {0, 80, 86}, {8, 0, 39}, {10, 0, 39}, {0, 3, -1}, {0, 21, 93}};
    public static final Predicate<InetAddress> FILTER_IPV4 = new Predicate<InetAddress>(){

        public boolean apply(InetAddress addr) {
            return addr instanceof Inet4Address;
        }
    };
    public static final Predicate<InetAddress> FILTER_NOT_LINK_LOCAL = new Predicate<InetAddress>(){

        public boolean apply(InetAddress addr) {
            return !addr.isLinkLocalAddress();
        }
    };

    @SafeVarargs
    public static Set<NetworkInterface> getNICs(Predicate<NetworkInterface> ... filters) {
        if (null == filters) {
            filters = new Predicate[]{Filter.ALL};
        }
        try {
            UnmodifiableIterator filtered = Iterators.filter((Iterator)Iterators.forEnumeration(NetworkInterface.getNetworkInterfaces()), (Predicate)Predicates.and(filters));
            return ImmutableSet.copyOf((Iterator)filtered);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    public static Set<NetworkInterface> getPhysicalNICs() {
        return NetworkUtil.getNICs(Filter.PHYICAL_ONLY, Filter.UP);
    }

    public static Set<NetworkInterface> getNoVirtualNICs() {
        return NetworkUtil.getNICs(Filter.NOVIRTUAL, Filter.UP);
    }

    public static final String format(byte[] source, String separator, final Radix radix) {
        if (null == source) {
            return "";
        }
        if (null == separator) {
            separator = "";
        }
        List list = Lists.transform((List)Bytes.asList((byte[])source), (Function)new Function<Byte, String>(){

            public String apply(Byte input) {
                switch (radix) {
                    case HEX: 
                    case HEX16: {
                        return String.format("%02x", input & 0xFF);
                    }
                }
                return Integer.toString(input & 0xFF, radix.value);
            }
        });
        if (Radix.HEX16.equals((Object)radix)) {
            return Joiner.on((String)"").join((Iterable)list).replaceAll(".{4}", separator + "$0").substring(1);
        }
        return Joiner.on((String)separator).join((Iterable)list);
    }

    public static final String formatMac(byte[] source, String separator) {
        return NetworkUtil.format(source, separator, Radix.HEX);
    }

    public static final String formatIp(byte[] source) {
        return NetworkUtil.format(source, ".", Radix.DEC);
    }

    public static final String formatIpv6(byte[] source) {
        return NetworkUtil.format(source, ":", Radix.HEX16);
    }

    public static final String formatIp(InetAddress inetAddress) {
        if (inetAddress instanceof Inet6Address) {
            return NetworkUtil.formatIpv6(inetAddress.getAddress());
        }
        if (inetAddress instanceof Inet4Address) {
            return NetworkUtil.formatIp(inetAddress.getAddress());
        }
        return null;
    }

    public static byte[] getMacAddress(InetAddress address) {
        try {
            NetworkInterface nic = NetworkInterface.getByInetAddress(address);
            return null == nic ? null : nic.getHardwareAddress();
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getMacAddress(NetworkInterface nic, String separator) {
        try {
            return NetworkUtil.format(nic.getHardwareAddress(), separator, Radix.HEX);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getMacAddress(InetAddress address, String separator) {
        return NetworkUtil.format(NetworkUtil.getMacAddress(address), separator, Radix.HEX);
    }

    private static boolean isVMMac(byte[] mac) {
        if (null == mac) {
            return false;
        }
        for (byte[] invalid : invalidMacs) {
            if (invalid[0] != mac[0] || invalid[1] != mac[1] || invalid[2] != mac[2]) continue;
            return true;
        }
        return false;
    }

    public static final boolean isLoopbackAddress(String host) {
        return "127.0.0.1".equals(host) || "::1".equals(host) || DEFAULT_HOST.equals(host);
    }

    public static final boolean isLocalhost(InetAddress address) {
        try {
            return address.isLoopbackAddress() || InetAddress.getLocalHost().getHostAddress().equals(address.getHostAddress());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static final boolean isLocalhost(String host) {
        try {
            return NetworkUtil.isLoopbackAddress(host) || NetworkUtil.isLocalhost(InetAddress.getByName((String)Preconditions.checkNotNull((Object)host)));
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static final String convertHost(String host) {
        return NetworkUtil.isLoopbackAddress(host) ? DEFAULT_HOST : host;
    }

    public static boolean selfBind(final InetAddress address) {
        if (NetworkUtil.isLocalhost(address)) {
            return true;
        }
        Predicate<InetAddress> filter = new Predicate<InetAddress>(){

            public boolean apply(InetAddress input) {
                return input.getHostAddress().equals(address.getHostAddress());
            }
        };
        return Iterators.tryFind(NetworkUtil.getNoVirtualNICs().iterator(), (Predicate)new Predicate<NetworkInterface>((Predicate)filter){
            final /* synthetic */ Predicate val$filter;
            {
                this.val$filter = predicate;
            }

            public boolean apply(NetworkInterface input) {
                return Iterators.tryFind((Iterator)Iterators.forEnumeration(input.getInetAddresses()), (Predicate)this.val$filter).isPresent();
            }
        }).isPresent();
    }

    public static boolean selfBind(String host) {
        try {
            return NetworkUtil.selfBind(InetAddress.getByName(host));
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InetAddress getLocalIp(String host, int port) throws IOException {
        try (Socket socket = null;){
            socket = new Socket(host, port);
            InetAddress inetAddress = socket.getLocalAddress();
            return inetAddress;
        }
    }

    public static InetAddress getLocalIp(HostAndPort hostAndPort) throws IOException, IllegalArgumentException {
        return NetworkUtil.getLocalIp(hostAndPort.getHost(), hostAndPort.getPort());
    }

    public static InetAddress getLocalIp(String hostPortString) throws IOException, IllegalArgumentException {
        HostAndPort hostAndPort = HostAndPort.fromString((String)hostPortString);
        return NetworkUtil.getLocalIp(hostAndPort.getHost(), hostAndPort.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InetAddress getLocalIp(String ... hostAndPorts) throws IOException {
        Preconditions.checkArgument((hostAndPorts != null && hostAndPorts.length > 0 ? 1 : 0) != 0, (Object)"hostAndPorts is null or empty");
        boolean hasNull = Iterables.tryFind(Arrays.asList(hostAndPorts), (Predicate)Predicates.isNull()).isPresent();
        Preconditions.checkArgument((!hasNull ? 1 : 0) != 0, (Object)"has null element in hostAndPorts");
        final AtomicReference mac = new AtomicReference();
        for (final String h : hostAndPorts) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block5: {
                        try {
                            InetAddress m = NetworkUtil.getLocalIp(h);
                            if (!mac.compareAndSet(null, m)) break block5;
                            AtomicReference atomicReference = mac;
                            synchronized (atomicReference) {
                                mac.notifyAll();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }.start();
        }
        try {
            AtomicReference interruptedException = mac;
            synchronized (interruptedException) {
                mac.wait(20000L);
            }
            if (null == mac.get()) {
                throw new IOException("ALL HOSTS CAN'T BE CONNECTED, FAIL TO get current mac");
            }
            return (InetAddress)mac.get();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("FAIL TO get current mac");
        }
    }

    public static byte[] getCurrentMac(String host, int port) throws IOException {
        InetAddress address = NetworkUtil.getLocalIp(host, port);
        NetworkInterface nic = NetworkInterface.getByInetAddress(address);
        return nic.getHardwareAddress();
    }

    public static byte[] getCurrentMac(HostAndPort hostAndPort) throws IOException {
        return NetworkUtil.getCurrentMac(hostAndPort.getHost(), hostAndPort.getPort());
    }

    public static byte[] getCurrentMac(String hostPortString) throws IOException {
        HostAndPort hostAndPort = HostAndPort.fromString((String)hostPortString);
        return NetworkUtil.getCurrentMac(hostAndPort.getHost(), hostAndPort.getPort());
    }

    public static byte[] getCurrentMac(String ... hostAndPorts) throws IOException {
        InetAddress address = NetworkUtil.getLocalIp(hostAndPorts);
        NetworkInterface nic = NetworkInterface.getByInetAddress(address);
        return nic.getHardwareAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpRequest(URL url, String requestType) {
        HttpURLConnection con = null;
        BufferedReader buffer = null;
        StringBuffer resultBuffer = null;
        try {
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod(requestType);
            con.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setUseCaches(false);
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                String line;
                InputStream inputStream = con.getInputStream();
                resultBuffer = new StringBuffer();
                buffer = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                while ((line = buffer.readLine()) != null) {
                    resultBuffer.append(line);
                }
                String string = resultBuffer.toString();
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        return null;
    }

    public static ConnectStatus testHttpConnect(URL url, Predicate<String> responseValidator) {
        String reponse = NetworkUtil.sendHttpRequest(url, "GET");
        responseValidator = (Predicate)MoreObjects.firstNonNull(responseValidator, (Object)Predicates.alwaysTrue());
        return reponse == null ? ConnectStatus.FAIL : (responseValidator.apply((Object)reponse) ? ConnectStatus.CONNECTABLE : ConnectStatus.INVALID_RESPONE);
    }

    public static ConnectStatus testHttpConnect(String url, Predicate<String> responseValidator) {
        try {
            return NetworkUtil.testHttpConnect(new URL(url), responseValidator);
        }
        catch (Exception e) {
            return ConnectStatus.FAIL;
        }
    }

    public static ConnectStatus testHttpConnect(String host, int port, Predicate<String> responseValidator) {
        try {
            return NetworkUtil.testHttpConnect(new URL("http", host, port, ""), responseValidator);
        }
        catch (Exception e) {
            return ConnectStatus.FAIL;
        }
    }

    public static boolean testHttpConnectChecked(URL url, Predicate<String> responseValidator) {
        ConnectStatus status = NetworkUtil.testHttpConnect(url, responseValidator);
        Preconditions.checkState((status != ConnectStatus.INVALID_RESPONE ? 1 : 0) != 0, (String)"INVALID INVALID_RESPONE from %s", (Object)url);
        return status == ConnectStatus.CONNECTABLE;
    }

    public static boolean testHttpConnectChecked(String url, Predicate<String> responseValidator) {
        try {
            return NetworkUtil.testHttpConnectChecked(new URL(url), responseValidator);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean testHttpConnectChecked(String host, int port, Predicate<String> responseValidator) {
        try {
            return NetworkUtil.testHttpConnectChecked(new URL("http", host, port, ""), responseValidator);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static final byte[] validateMac(byte[] mac) {
        Preconditions.checkArgument((null != mac && 6 == mac.length ? 1 : 0) != 0, (Object)"INVAILD MAC address");
        return mac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMulticast(InetAddress group, int port, byte[] message, Integer ttl, NetworkInterface nic) throws IOException {
        Preconditions.checkArgument((null != group ? 1 : 0) != 0, (Object)"group is null");
        Preconditions.checkArgument((group.isMulticastAddress() || NetworkUtil.isBroadcast(group) ? 1 : 0) != 0, (String)"group %s is not a multicast or broadcast address", (Object)group);
        Preconditions.checkArgument((message != null && message.length > 0 ? 1 : 0) != 0, (Object)"message is null or empty");
        Preconditions.checkArgument((null != nic ? 1 : 0) != 0, (Object)"nic is null");
        UnmodifiableIterator nifAddresses = Iterators.filter((Iterator)Iterators.forEnumeration(nic.getInetAddresses()), (Predicate)Predicates.and(FILTER_IPV4, FILTER_NOT_LINK_LOCAL));
        if (!nifAddresses.hasNext()) {
            return;
        }
        InetSocketAddress inetAddr = new InetSocketAddress((InetAddress)nifAddresses.next(), 0);
        try (DatagramSocket ds = null;){
            if (group.isMulticastAddress()) {
                MulticastSocket ms = new MulticastSocket(inetAddr);
                if (ttl != null) {
                    ms.setTimeToLive(ttl);
                }
                ds = ms;
            } else {
                ds = new DatagramSocket(inetAddr);
                ds.setBroadcast(true);
            }
            ds.send(new DatagramPacket(message, message.length, group, port));
        }
    }

    public static void sendMulticast(InetAddress group, int port, byte[] message, Integer ttl) throws IOException {
        Preconditions.checkArgument((null != group ? 1 : 0) != 0, (Object)"group is null");
        Preconditions.checkArgument((group.isMulticastAddress() || NetworkUtil.isBroadcast(group) ? 1 : 0) != 0, (String)"group %s is not a multicast or broadcast address", (Object)group);
        Preconditions.checkArgument((message != null && message.length > 0 ? 1 : 0) != 0, (Object)"message is null or empty");
        int count = 0;
        IOException last = null;
        Set<NetworkInterface> ethNICs = NetworkUtil.getNICs(Filter.UP, Filter.ETH_NIC);
        if (ethNICs.isEmpty()) {
            throw new IOException("NOT FOUND ETHERNET NIC");
        }
        for (NetworkInterface nic : ethNICs) {
            try {
                NetworkUtil.sendMulticast(group, port, message, ttl, nic);
                ++count;
            }
            catch (IOException e) {
                last = e;
            }
        }
        if (count == 0) {
            throw new IOException("FAIL TO SEND multicast/broadcast Datagram to " + group + ":" + port + " ON ALL NICS", last);
        }
    }

    public static void sendMulticast(String bindaddr, int port, byte[] message) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bindaddr) ? 1 : 0) != 0, (Object)"bindaddr is null or empty");
        NetworkUtil.sendMulticast(InetAddress.getByName(bindaddr), port, message, null);
    }

    public static void sendMulticast(String hostPort, byte[] message) throws IOException {
        HostAndPort hostAndPort = HostAndPort.fromString((String)hostPort);
        NetworkUtil.sendMulticast(InetAddress.getByName(hostAndPort.getHost()), hostAndPort.getPort(), message, null);
    }

    public static Set<InetAddress> ipv4AddressesOfPhysicalNICs() {
        return NetworkUtil.addressesOfPhysicalNICs(FILTER_IPV4, FILTER_NOT_LINK_LOCAL);
    }

    @SafeVarargs
    public static Set<InetAddress> addressesOfPhysicalNICs(Predicate<InetAddress> ... filters) {
        filters = (Predicate[])MoreObjects.firstNonNull(filters, (Object)new Predicate[0]);
        HashSet sets = Sets.newHashSet();
        for (NetworkInterface nic : NetworkUtil.getPhysicalNICs()) {
            UnmodifiableIterator itor = Iterators.filter((Iterator)Iterators.forEnumeration(nic.getInetAddresses()), (Predicate)Predicates.and(filters));
            sets.addAll(Sets.newHashSet((Iterator)itor));
        }
        return sets;
    }

    public static Set<InetAddress> ipv4AddressesOfNoVirtualNICs() {
        return NetworkUtil.addressesOfNoVirtualNICs(FILTER_IPV4, FILTER_NOT_LINK_LOCAL);
    }

    @SafeVarargs
    public static Set<InetAddress> addressesOfNoVirtualNICs(Predicate<InetAddress> ... filters) {
        filters = (Predicate[])MoreObjects.firstNonNull(filters, (Object)new Predicate[0]);
        HashSet sets = Sets.newHashSet();
        for (NetworkInterface nic : NetworkUtil.getNoVirtualNICs()) {
            UnmodifiableIterator itor = Iterators.filter((Iterator)Iterators.forEnumeration(nic.getInetAddresses()), (Predicate)Predicates.and(filters));
            sets.addAll(Sets.newHashSet((Iterator)itor));
        }
        return sets;
    }

    public static boolean isReachable(String address, int port, int timeoutMillis) {
        try {
            try (Socket soc = new Socket();){
                soc.connect(new InetSocketAddress(address, port), timeoutMillis);
            }
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isBroadcast(InetAddress addr) {
        return addr.getHostAddress().equals("255.255.255.255");
    }

    public static enum ConnectStatus {
        CONNECTABLE,
        INVALID_RESPONE,
        FAIL;

    }

    public static enum Filter implements Predicate<NetworkInterface>
    {
        ALL,
        UP,
        VIRTUAL,
        LOOPBACK,
        PHYICAL_ONLY,
        ETH_NIC,
        NOVIRTUAL;


        public boolean apply(NetworkInterface input) {
            if (null == input) {
                return false;
            }
            try {
                switch (this) {
                    case UP: {
                        return input.isUp();
                    }
                    case VIRTUAL: {
                        return input.isVirtual();
                    }
                    case LOOPBACK: {
                        return input.isLoopback();
                    }
                    case PHYICAL_ONLY: {
                        byte[] hardwareAddress = input.getHardwareAddress();
                        return null != hardwareAddress && hardwareAddress.length > 0 && !input.isVirtual() && !NetworkUtil.isVMMac(hardwareAddress);
                    }
                    case ETH_NIC: {
                        byte[] hardwareAddress = input.getHardwareAddress();
                        return null != hardwareAddress && hardwareAddress.length > 0 && !input.isVirtual() && !input.isLoopback() && input.getInetAddresses().hasMoreElements();
                    }
                    case NOVIRTUAL: {
                        byte[] hardwareAddress = input.getHardwareAddress();
                        return null != hardwareAddress && hardwareAddress.length > 0 && !input.isVirtual();
                    }
                }
                return true;
            }
            catch (SocketException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static enum Radix {
        BIN(2),
        DEC(10),
        HEX(16),
        HEX16(16);

        public final int value;

        private Radix(int radix) {
            this.value = radix;
        }
    }
}

