/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap;

import com.gitee.starblues.bootstrap.SpringPluginBootstrapBinder;
import com.gitee.starblues.bootstrap.coexist.CoexistAllowAutoConfiguration;
import com.gitee.starblues.common.PluginDisableAutoConfig;
import com.gitee.starblues.loader.launcher.DevelopmentModeSetting;
import com.gitee.starblues.utils.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfigurationImportFilter;
import org.springframework.boot.autoconfigure.AutoConfigurationMetadata;

public class PluginDisableAutoConfiguration
implements AutoConfigurationImportFilter {
    private static final ThreadLocal<Boolean> LAUNCH_PLUGIN = new ThreadLocal();

    public static void setLaunchPlugin() {
        LAUNCH_PLUGIN.set(true);
    }

    public boolean[] match(String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
        if (DevelopmentModeSetting.isolation()) {
            return new IsolationDisableAutoConfiguration().match(autoConfigurationClasses, autoConfigurationMetadata);
        }
        if (DevelopmentModeSetting.coexist()) {
            return new CoexistDisableAutoConfiguration().match(autoConfigurationClasses, autoConfigurationMetadata);
        }
        boolean[] permitAll = new boolean[autoConfigurationClasses.length];
        for (int i = 0; i < autoConfigurationClasses.length; ++i) {
            permitAll[i] = PluginDisableAutoConfiguration.permit(PluginDisableAutoConfig.getCommonPluginDisableAutoConfig(), autoConfigurationClasses[i]);
        }
        return permitAll;
    }

    private static boolean permit(Collection<String> disableCollection, String className) {
        if (ObjectUtils.isEmpty((CharSequence)className)) {
            return true;
        }
        for (String disableFuzzyClass : disableCollection) {
            if (!className.contains(disableFuzzyClass)) continue;
            return false;
        }
        return true;
    }

    private static class CoexistDisableAutoConfiguration
    implements AutoConfigurationImportFilter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean[] match(String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
            Boolean launchPlugin = (Boolean)LAUNCH_PLUGIN.get();
            boolean[] match = new boolean[autoConfigurationClasses.length];
            try {
                if (launchPlugin != null && launchPlugin.booleanValue()) {
                    CoexistAllowAutoConfiguration configuration = SpringPluginBootstrapBinder.get().getCoexistAllowAutoConfiguration();
                    for (int i = 0; i < autoConfigurationClasses.length; ++i) {
                        String autoConfigurationClass = autoConfigurationClasses[i];
                        if (ObjectUtils.isEmpty((CharSequence)autoConfigurationClass)) continue;
                        match[i] = PluginDisableAutoConfiguration.permit(PluginDisableAutoConfig.getCommonPluginDisableAutoConfig(), autoConfigurationClass) ? configuration.match(autoConfigurationClass) : false;
                    }
                    boolean[] blArray = match;
                    return blArray;
                }
                for (int i = 0; i < autoConfigurationClasses.length; ++i) {
                    match[i] = true;
                }
                boolean[] blArray = match;
                return blArray;
            }
            finally {
                LAUNCH_PLUGIN.remove();
            }
        }
    }

    private static class IsolationDisableAutoConfiguration
    implements AutoConfigurationImportFilter {
        private final List<String> disableFuzzyClass = new ArrayList<String>();

        IsolationDisableAutoConfiguration() {
            this.addDisableFuzzyClasses();
        }

        private void addDisableFuzzyClasses() {
            this.disableFuzzyClass.add("org.springframework.boot.autoconfigure.http");
            this.disableFuzzyClass.add("org.springframework.boot.autoconfigure.web");
            this.disableFuzzyClass.add("org.springframework.boot.autoconfigure.websocket");
            this.disableFuzzyClass.add("org.springframework.boot.autoconfigure.jackson");
            this.disableFuzzyClass.add("org.springframework.boot.autoconfigure.webservices");
            this.disableFuzzyClass.addAll(PluginDisableAutoConfig.getCommonPluginDisableAutoConfig());
        }

        public boolean[] match(String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
            boolean[] match = new boolean[autoConfigurationClasses.length];
            for (int i = 0; i < autoConfigurationClasses.length; ++i) {
                String autoConfigurationClass = autoConfigurationClasses[i];
                if (autoConfigurationClass == null || "".equals(autoConfigurationClass)) continue;
                match[i] = PluginDisableAutoConfiguration.permit(this.disableFuzzyClass, autoConfigurationClass);
            }
            return match;
        }
    }
}

