/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap;

import com.gitee.starblues.bootstrap.AutowiredTypeResolver;
import com.gitee.starblues.bootstrap.DefaultAutowiredTypeResolver;
import com.gitee.starblues.bootstrap.annotation.AutowiredType;
import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.bootstrap.utils.DestroyUtils;
import com.gitee.starblues.spring.MainApplicationContext;
import com.gitee.starblues.spring.SpringBeanFactory;
import com.gitee.starblues.utils.ReflectionUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.lang.Nullable;

public class PluginListableBeanFactory
extends DefaultListableBeanFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PluginListableBeanFactory.class);
    private final MainApplicationContext applicationContext;
    private AutowiredTypeResolver autowiredTypeResolver;

    public PluginListableBeanFactory(ProcessorContext processorContext) {
        this.applicationContext = processorContext.getMainApplicationContext();
        this.autowiredTypeResolver = this.getAutowiredTypeResolver(processorContext);
    }

    protected AutowiredTypeResolver getAutowiredTypeResolver(ProcessorContext processorContext) {
        return new DefaultAutowiredTypeResolver(processorContext);
    }

    public Object resolveDependency(DependencyDescriptor descriptor, @Nullable String requestingBeanName, @Nullable Set<String> autowiredBeanNames, @Nullable TypeConverter typeConverter) throws BeansException {
        AutowiredType.Type autowiredType = this.getAutowiredType(descriptor);
        Class dependencyType = descriptor.getDependencyType();
        if (dependencyType == ObjectFactory.class || dependencyType == ObjectProvider.class) {
            Object dependencyObj = super.resolveDependency(descriptor, requestingBeanName, autowiredBeanNames, typeConverter);
            ObjectProvider provider = (ObjectProvider)dependencyObj;
            return new PluginObjectProviderWrapper(provider, requestingBeanName, descriptor, autowiredType);
        }
        if (autowiredType == AutowiredType.Type.MAIN) {
            Object dependencyObj = this.resolveDependencyFromMain(requestingBeanName, descriptor);
            if (dependencyObj != null) {
                return dependencyObj;
            }
            throw new NoSuchBeanDefinitionException(descriptor.getDependencyType());
        }
        if (autowiredType == AutowiredType.Type.PLUGIN) {
            return super.resolveDependency(descriptor, requestingBeanName, autowiredBeanNames, typeConverter);
        }
        if (autowiredType == AutowiredType.Type.PLUGIN_MAIN) {
            try {
                return super.resolveDependency(descriptor, requestingBeanName, autowiredBeanNames, typeConverter);
            }
            catch (BeansException e) {
                Object dependencyObj;
                if (e instanceof NoSuchBeanDefinitionException && (dependencyObj = this.resolveDependencyFromMain(requestingBeanName, descriptor)) != null) {
                    return dependencyObj;
                }
                throw e;
            }
        }
        if (autowiredType == AutowiredType.Type.MAIN_PLUGIN) {
            Object dependencyObj = this.resolveDependencyFromMain(requestingBeanName, descriptor);
            if (dependencyObj instanceof ObjectProvider) {
                ObjectProvider provider = (ObjectProvider)dependencyObj;
                return new PluginObjectProviderWrapper(provider, requestingBeanName, descriptor, autowiredType);
            }
            if (dependencyObj != null) {
                return dependencyObj;
            }
            return super.resolveDependency(descriptor, requestingBeanName, autowiredBeanNames, typeConverter);
        }
        throw new NoSuchBeanDefinitionException(descriptor.getDependencyType());
    }

    public void destroySingletons() {
        String[] beanDefinitionNames;
        for (String beanDefinitionName : beanDefinitionNames = this.getBeanDefinitionNames()) {
            this.destroyBean(beanDefinitionName);
        }
        super.destroySingletons();
        this.destroyAll();
    }

    public <T> ObjectProvider<T> getBeanProvider(Class<T> requiredType, boolean allowEagerInit) {
        return super.getBeanProvider(requiredType, allowEagerInit);
    }

    protected AutowiredType.Type getAutowiredType(DependencyDescriptor descriptor) {
        return this.autowiredTypeResolver.resolve(descriptor);
    }

    protected Object resolveDependencyFromMain(String requestingBeanName, DependencyDescriptor descriptor) {
        Object dependencyObj = null;
        try {
            dependencyObj = this.applicationContext.resolveDependency(requestingBeanName, descriptor.getDependencyType());
        }
        catch (Exception e) {
            return null;
        }
        return dependencyObj;
    }

    private void destroyAll() {
        ReflectionUtils.findField(((Object)((Object)this)).getClass(), field -> {
            field.setAccessible(true);
            try {
                Object o = field.get((Object)this);
                DestroyUtils.destroyAll(o);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return false;
        });
    }

    public void setAutowiredTypeResolver(AutowiredTypeResolver autowiredTypeResolver) {
        this.autowiredTypeResolver = autowiredTypeResolver;
    }

    private static class NestedDependencyDescriptor
    extends DependencyDescriptor {
        public NestedDependencyDescriptor(DependencyDescriptor original) {
            super(original);
            this.increaseNestingLevel();
        }
    }

    private class PluginObjectProviderWrapper
    implements ObjectProvider<Object> {
        private final ObjectProvider<Object> pluginObjectProvider;
        private final String requestingBeanName;
        private final DependencyDescriptor descriptor;
        private final AutowiredType.Type autowiredType;

        private PluginObjectProviderWrapper(ObjectProvider<Object> pluginObjectProvider, String requestingBeanName, DependencyDescriptor descriptor, AutowiredType.Type autowiredType) {
            this.pluginObjectProvider = pluginObjectProvider;
            this.requestingBeanName = requestingBeanName;
            this.descriptor = new NestedDependencyDescriptor(descriptor);
            this.autowiredType = autowiredType;
        }

        public Object getObject() throws BeansException {
            if (this.autowiredType == AutowiredType.Type.PLUGIN) {
                return this.pluginObjectProvider.getObject();
            }
            if (this.autowiredType == AutowiredType.Type.MAIN) {
                Object dependencyObj = PluginListableBeanFactory.this.resolveDependencyFromMain(this.requestingBeanName, this.descriptor);
                if (dependencyObj != null) {
                    return dependencyObj;
                }
            } else {
                if (this.autowiredType == AutowiredType.Type.PLUGIN_MAIN) {
                    try {
                        return this.pluginObjectProvider.getObject();
                    }
                    catch (Exception e) {
                        Object dependencyObj = PluginListableBeanFactory.this.resolveDependencyFromMain(this.requestingBeanName, this.descriptor);
                        if (dependencyObj != null) {
                            return dependencyObj;
                        }
                        throw e;
                    }
                }
                if (this.autowiredType == AutowiredType.Type.MAIN_PLUGIN) {
                    Object dependencyObj = PluginListableBeanFactory.this.resolveDependencyFromMain(this.requestingBeanName, this.descriptor);
                    if (dependencyObj != null) {
                        return dependencyObj;
                    }
                    return this.pluginObjectProvider.getObject();
                }
            }
            throw new NoSuchBeanDefinitionException(this.descriptor.getResolvableType());
        }

        public Object getObject(Object ... args) throws BeansException {
            if (this.autowiredType == AutowiredType.Type.PLUGIN) {
                return this.pluginObjectProvider.getObject(args);
            }
            if (this.autowiredType == AutowiredType.Type.MAIN) {
                Object dependencyObj = PluginListableBeanFactory.this.resolveDependencyFromMain(this.requestingBeanName, this.descriptor);
                if (dependencyObj != null) {
                    return dependencyObj;
                }
            } else {
                if (this.autowiredType == AutowiredType.Type.PLUGIN_MAIN) {
                    try {
                        return this.pluginObjectProvider.getObject();
                    }
                    catch (Exception e) {
                        try {
                            return PluginListableBeanFactory.this.applicationContext.getSpringBeanFactory().getBean(this.requestingBeanName, args);
                        }
                        catch (Exception exception) {
                            throw e;
                        }
                    }
                }
                if (this.autowiredType == AutowiredType.Type.MAIN_PLUGIN) {
                    Object dependencyObj = PluginListableBeanFactory.this.resolveDependencyFromMain(this.requestingBeanName, this.descriptor);
                    if (dependencyObj != null) {
                        return dependencyObj;
                    }
                    return this.pluginObjectProvider.getObject(args);
                }
            }
            throw new NoSuchBeanDefinitionException(this.descriptor.getResolvableType());
        }

        @Nullable
        public Object getIfAvailable() throws BeansException {
            if (this.autowiredType == AutowiredType.Type.PLUGIN) {
                return this.pluginObjectProvider.getIfAvailable();
            }
            if (this.autowiredType == AutowiredType.Type.MAIN) {
                return PluginListableBeanFactory.this.resolveDependencyFromMain(this.requestingBeanName, this.descriptor);
            }
            if (this.autowiredType == AutowiredType.Type.PLUGIN_MAIN) {
                Object dependencyObj = this.pluginObjectProvider.getIfAvailable();
                if (dependencyObj == null) {
                    dependencyObj = PluginListableBeanFactory.this.resolveDependencyFromMain(this.requestingBeanName, this.descriptor);
                }
                return dependencyObj;
            }
            if (this.autowiredType == AutowiredType.Type.MAIN_PLUGIN) {
                Object dependencyObj = PluginListableBeanFactory.this.resolveDependencyFromMain(this.requestingBeanName, this.descriptor);
                if (dependencyObj != null) {
                    return dependencyObj;
                }
                return this.pluginObjectProvider.getIfAvailable();
            }
            return null;
        }

        public void ifAvailable(Consumer<Object> dependencyConsumer) throws BeansException {
            Object ifAvailable = this.getIfAvailable();
            if (ifAvailable != null) {
                dependencyConsumer.accept(ifAvailable);
            }
        }

        @Nullable
        public Object getIfUnique() throws BeansException {
            if (this.autowiredType == AutowiredType.Type.PLUGIN) {
                return this.pluginObjectProvider.getIfUnique();
            }
            if (this.autowiredType == AutowiredType.Type.MAIN) {
                return PluginListableBeanFactory.this.resolveDependencyFromMain(this.requestingBeanName, this.descriptor);
            }
            if (this.autowiredType == AutowiredType.Type.PLUGIN_MAIN) {
                Object dependencyObj = this.pluginObjectProvider.getIfUnique();
                if (dependencyObj == null) {
                    dependencyObj = PluginListableBeanFactory.this.resolveDependencyFromMain(this.requestingBeanName, this.descriptor);
                }
                return dependencyObj;
            }
            if (this.autowiredType == AutowiredType.Type.MAIN_PLUGIN) {
                Object dependencyObj = PluginListableBeanFactory.this.resolveDependencyFromMain(this.requestingBeanName, this.descriptor);
                if (dependencyObj != null) {
                    return dependencyObj;
                }
                return this.pluginObjectProvider.getIfUnique();
            }
            return null;
        }

        public void ifUnique(Consumer<Object> dependencyConsumer) throws BeansException {
            Object ifUnique = this.getIfUnique();
            if (ifUnique != null) {
                dependencyConsumer.accept(ifUnique);
            }
        }

        public Stream<Object> stream() {
            if (this.autowiredType == AutowiredType.Type.PLUGIN) {
                return this.pluginObjectProvider.stream();
            }
            if (this.autowiredType == AutowiredType.Type.MAIN) {
                return this.getStreamOfMain().stream();
            }
            if (this.autowiredType == AutowiredType.Type.PLUGIN_MAIN) {
                Stream stream = this.pluginObjectProvider.stream();
                List collect = stream.collect(Collectors.toList());
                if (!collect.isEmpty()) {
                    return collect.stream();
                }
                return this.getStreamOfMain().stream();
            }
            if (this.autowiredType == AutowiredType.Type.MAIN_PLUGIN) {
                Set<Object> collection = this.getStreamOfMain();
                if (!collection.isEmpty()) {
                    return collection.stream();
                }
                return this.pluginObjectProvider.stream();
            }
            return Stream.empty();
        }

        public Stream<Object> orderedStream() {
            if (this.autowiredType == AutowiredType.Type.PLUGIN) {
                return this.pluginObjectProvider.orderedStream();
            }
            if (this.autowiredType == AutowiredType.Type.MAIN) {
                return this.getStreamOfMain().stream().sorted();
            }
            if (this.autowiredType == AutowiredType.Type.PLUGIN_MAIN) {
                Stream stream = this.pluginObjectProvider.stream();
                List collect = stream.collect(Collectors.toList());
                if (!collect.isEmpty()) {
                    return collect.stream();
                }
                return this.getStreamOfMain().stream().sorted();
            }
            if (this.autowiredType == AutowiredType.Type.MAIN_PLUGIN) {
                Set<Object> collection = this.getStreamOfMain();
                if (!collection.isEmpty()) {
                    return collection.stream().sorted();
                }
                return this.pluginObjectProvider.stream();
            }
            return Stream.empty();
        }

        private Set<Object> getStreamOfMain() {
            SpringBeanFactory springBeanFactory = PluginListableBeanFactory.this.applicationContext.getSpringBeanFactory();
            Map beansOfType = springBeanFactory.getBeansOfType(this.descriptor.getDependencyType());
            return new HashSet<Object>(beansOfType.values());
        }
    }
}

