/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap;

import com.gitee.starblues.bootstrap.PluginOneselfInteractive;
import com.gitee.starblues.bootstrap.SpringPluginBootstrapBinder;
import com.gitee.starblues.bootstrap.coexist.CoexistAllowAutoConfiguration;
import com.gitee.starblues.bootstrap.launcher.BootstrapLauncher;
import com.gitee.starblues.bootstrap.launcher.BootstrapLauncherFactory;
import com.gitee.starblues.bootstrap.launcher.DefaultBootstrapLauncherFactory;
import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.bootstrap.processor.SpringPluginProcessor;
import com.gitee.starblues.bootstrap.realize.AutowiredTypeDefiner;
import com.gitee.starblues.core.launcher.plugin.PluginInteractive;
import com.gitee.starblues.spring.SpringPluginHook;
import java.util.ArrayList;
import java.util.List;

public abstract class SpringPluginBootstrap {
    private ProcessorContext.RunMode runMode = ProcessorContext.RunMode.ONESELF;
    private volatile PluginInteractive pluginInteractive;
    private final List<SpringPluginProcessor> customPluginProcessors = new ArrayList<SpringPluginProcessor>();
    private final CoexistAllowAutoConfiguration coexistAllowAutoConfiguration = new CoexistAllowAutoConfiguration();
    private final BootstrapLauncherFactory launcherFactory = new DefaultBootstrapLauncherFactory();

    public SpringPluginBootstrap() {
        SpringPluginBootstrapBinder.set(this);
    }

    public final SpringPluginHook run(String[] args) {
        return this.run(this.getClass(), args);
    }

    public final SpringPluginHook run(Class<?> primarySources, String[] args) {
        return this.run(new Class[]{primarySources}, args);
    }

    public final SpringPluginHook run(Class<?>[] primarySources, String[] args) {
        return this.start(primarySources, args);
    }

    private SpringPluginHook start(Class<?>[] primarySources, String[] args) {
        this.configCoexistAllowAutoConfiguration(this.coexistAllowAutoConfiguration);
        this.createPluginInteractive();
        this.addCustomSpringPluginProcessor();
        BootstrapLauncher bootstrapLauncher = this.launcherFactory.create(this);
        return bootstrapLauncher.launch(primarySources, args);
    }

    public final SpringPluginBootstrap setPluginInteractive(PluginInteractive pluginInteractive) {
        this.pluginInteractive = pluginInteractive;
        this.runMode = ProcessorContext.RunMode.PLUGIN;
        return this;
    }

    public final SpringPluginBootstrap addSpringPluginProcessor(SpringPluginProcessor springPluginProcessor) {
        if (springPluginProcessor != null) {
            this.customPluginProcessors.add(springPluginProcessor);
        }
        return this;
    }

    protected final void createPluginInteractive() {
        if (this.pluginInteractive != null) {
            return;
        }
        this.createPluginInteractiveOfOneself();
    }

    protected final void createPluginInteractiveOfOneself() {
        this.pluginInteractive = new PluginOneselfInteractive();
    }

    protected void addCustomSpringPluginProcessor() {
    }

    protected AutowiredTypeDefiner autowiredTypeDefiner() {
        return null;
    }

    protected void configCoexistAllowAutoConfiguration(CoexistAllowAutoConfiguration configuration) {
    }

    public ProcessorContext.RunMode getRunMode() {
        return this.runMode;
    }

    public PluginInteractive getPluginInteractive() {
        return this.pluginInteractive;
    }

    public List<SpringPluginProcessor> getCustomPluginProcessors() {
        return this.customPluginProcessors;
    }

    public CoexistAllowAutoConfiguration getCoexistAllowAutoConfiguration() {
        return this.coexistAllowAutoConfiguration;
    }
}

