/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap.coexist;

import com.gitee.starblues.bootstrap.annotation.ResolveClassLoader;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class CoexistResolveClassLoaderAspect {
    @Pointcut(value="@annotation(com.gitee.starblues.bootstrap.annotation.ResolveClassLoader)")
    public void test() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(resolveClassLoader)")
    public Object around(ProceedingJoinPoint pjp, ResolveClassLoader resolveClassLoader) throws Throwable {
        Thread thread = Thread.currentThread();
        ClassLoader oldClassLoader = thread.getContextClassLoader();
        try {
            Object target = pjp.getTarget();
            thread.setContextClassLoader(target.getClass().getClassLoader());
            Object object = pjp.proceed();
            return object;
        }
        finally {
            thread.setContextClassLoader(oldClassLoader);
        }
    }
}

