/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap.processor;

import com.gitee.starblues.bootstrap.SpringPluginBootstrap;
import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.core.PluginInfo;
import com.gitee.starblues.core.descriptor.InsidePluginDescriptor;
import com.gitee.starblues.core.launcher.plugin.CacheRegistryInfo;
import com.gitee.starblues.core.launcher.plugin.PluginInteractive;
import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.spring.MainApplicationContext;
import com.gitee.starblues.spring.SpringBeanFactory;
import com.gitee.starblues.spring.WebConfig;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;

public class DefaultProcessorContext
extends CacheRegistryInfo
implements ProcessorContext {
    private final ProcessorContext.RunMode runMode;
    private final SpringPluginBootstrap springPluginBootstrap;
    private final PluginInteractive pluginInteractive;
    private final Class<? extends SpringPluginBootstrap> runnerClass;
    private final MainApplicationContext mainApplicationContext;
    private final ClassLoader classLoader;
    private final ResourceLoader resourceLoader;
    private final IntegrationConfiguration configuration;
    private final WebConfig webConfig;
    private GenericApplicationContext applicationContext;

    public DefaultProcessorContext(ProcessorContext.RunMode runMode, SpringPluginBootstrap springPluginBootstrap, PluginInteractive pluginInteractive, Class<? extends SpringPluginBootstrap> runnerClass) {
        this.runMode = runMode;
        this.springPluginBootstrap = springPluginBootstrap;
        this.pluginInteractive = pluginInteractive;
        this.runnerClass = runnerClass;
        this.classLoader = this.getPluginClassLoader();
        this.resourceLoader = new DefaultResourceLoader(this.classLoader);
        this.mainApplicationContext = pluginInteractive.getMainApplicationContext();
        this.configuration = pluginInteractive.getConfiguration();
        this.webConfig = new WebConfig();
    }

    @Override
    public ProcessorContext.RunMode runMode() {
        return this.runMode;
    }

    @Override
    public SpringPluginBootstrap getSpringPluginBootstrap() {
        return this.springPluginBootstrap;
    }

    @Override
    public InsidePluginDescriptor getPluginDescriptor() {
        return this.pluginInteractive.getPluginDescriptor();
    }

    @Override
    public PluginInfo getPluginInfo() {
        return this.pluginInteractive.getPluginInsideInfo();
    }

    @Override
    public Class<? extends SpringPluginBootstrap> getRunnerClass() {
        return this.runnerClass;
    }

    @Override
    public PluginInteractive getPluginInteractive() {
        return this.pluginInteractive;
    }

    @Override
    public MainApplicationContext getMainApplicationContext() {
        return this.mainApplicationContext;
    }

    @Override
    public SpringBeanFactory getMainBeanFactory() {
        return this.mainApplicationContext.getSpringBeanFactory();
    }

    @Override
    public IntegrationConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public GenericApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            return null;
        }
        return this.applicationContext;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    public WebConfig getWebConfig() {
        return this.webConfig;
    }

    @Override
    public void setApplicationContext(GenericApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected ClassLoader getPluginClassLoader() {
        return ClassUtils.getDefaultClassLoader();
    }
}

