/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap.processor;

import com.gitee.starblues.annotation.Extract;
import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.bootstrap.processor.ProcessorException;
import com.gitee.starblues.bootstrap.processor.SpringPluginProcessor;
import com.gitee.starblues.spring.extract.OpExtractFactory;
import com.gitee.starblues.utils.ObjectUtils;
import java.util.Map;
import org.springframework.context.support.GenericApplicationContext;

public class ExtractBeanProcessor
implements SpringPluginProcessor {
    @Override
    public void refreshAfter(ProcessorContext context) throws ProcessorException {
        GenericApplicationContext applicationContext = context.getApplicationContext();
        Map extractMap = applicationContext.getBeansWithAnnotation(Extract.class);
        if (ObjectUtils.isEmpty((Object)extractMap)) {
            return;
        }
        String pluginId = context.getPluginDescriptor().getPluginId();
        OpExtractFactory opExtractFactory = context.getPluginInteractive().getOpExtractFactory();
        for (Object extract : extractMap.values()) {
            opExtractFactory.add(pluginId, extract);
        }
    }

    @Override
    public void close(ProcessorContext context) throws ProcessorException {
        OpExtractFactory opExtractFactory = context.getPluginInteractive().getOpExtractFactory();
        String pluginId = context.getPluginDescriptor().getPluginId();
        opExtractFactory.remove(pluginId);
    }

    @Override
    public ProcessorContext.RunMode runMode() {
        return ProcessorContext.RunMode.ALL;
    }
}

