/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap.processor.web;

import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.bootstrap.processor.ProcessorException;
import com.gitee.starblues.bootstrap.processor.SpringPluginProcessor;
import com.gitee.starblues.bootstrap.utils.AnnotationUtils;
import com.gitee.starblues.bootstrap.utils.DestroyUtils;
import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.spring.ApplicationContext;
import com.gitee.starblues.spring.SpringBeanFactory;
import com.gitee.starblues.utils.ObjectUtils;
import com.gitee.starblues.utils.PluginConfigUtils;
import com.gitee.starblues.utils.SpringBeanCustomUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class PluginControllerProcessor
implements SpringPluginProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(PluginControllerProcessor.class);
    static final String PROCESS_CONTROLLERS = "PROCESS_SUCCESS";
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    private RequestMappingHandlerAdapter handlerAdapter;
    private final AtomicBoolean canRegistered = new AtomicBoolean(false);

    @Override
    public void initialize(ProcessorContext processorContext) throws ProcessorException {
        SpringBeanFactory mainBeanFactory = processorContext.getMainBeanFactory();
        this.requestMappingHandlerMapping = (RequestMappingHandlerMapping)mainBeanFactory.getBean(RequestMappingHandlerMapping.class);
        this.handlerAdapter = (RequestMappingHandlerAdapter)SpringBeanCustomUtils.getExistBean((ApplicationContext)processorContext.getMainApplicationContext(), RequestMappingHandlerAdapter.class);
        this.canRegistered.set(true);
    }

    @Override
    public void refreshBefore(ProcessorContext processorContext) throws ProcessorException {
        if (!this.canRegistered.get()) {
            return;
        }
        GenericApplicationContext applicationContext = processorContext.getApplicationContext();
        applicationContext.getDefaultListableBeanFactory().addBeanPostProcessor((BeanPostProcessor)new ControllerPostProcessor(processorContext));
    }

    @Override
    public void refreshAfter(ProcessorContext processorContext) throws ProcessorException {
        if (!this.canRegistered.get()) {
            return;
        }
        String pluginId = processorContext.getPluginDescriptor().getPluginId();
        List controllerWrappers = (List)processorContext.getRegistryInfo(PROCESS_CONTROLLERS);
        if (ObjectUtils.isEmpty((Object)controllerWrappers)) {
            return;
        }
        GenericApplicationContext applicationContext = processorContext.getApplicationContext();
        Iterator iterator = controllerWrappers.iterator();
        String pathPrefix = PluginConfigUtils.getPluginRestPrefix((IntegrationConfiguration)processorContext.getConfiguration(), (String)pluginId);
        PluginRequestMappingHandlerMapping pluginHandlerMapping = new PluginRequestMappingHandlerMapping(pathPrefix);
        while (iterator.hasNext()) {
            ControllerWrapper controllerWrapper = (ControllerWrapper)iterator.next();
            if (!applicationContext.containsBean(controllerWrapper.getBeanName())) {
                iterator.remove();
            }
            Object controllerBean = applicationContext.getBean(controllerWrapper.getBeanName());
            pluginHandlerMapping.registerHandler(controllerBean);
            List<RegisterMappingInfo> registerMappingInfo = pluginHandlerMapping.getAndClear();
            HashSet<RequestMappingInfo> requestMappingInfoSet = new HashSet<RequestMappingInfo>(registerMappingInfo.size());
            for (RegisterMappingInfo mappingInfo : registerMappingInfo) {
                RequestMappingInfo requestMappingInfo = mappingInfo.getRequestMappingInfo();
                this.requestMappingHandlerMapping.registerMapping(requestMappingInfo, mappingInfo.getHandler(), mappingInfo.getMethod());
                LOG.info("\u63d2\u4ef6[{}]\u6ce8\u518c\u63a5\u53e3: {}", (Object)pluginId, (Object)requestMappingInfo);
                requestMappingInfoSet.add(requestMappingInfo);
            }
            controllerWrapper.setRequestMappingInfo(requestMappingInfoSet);
        }
    }

    @Override
    public void close(ProcessorContext context) throws ProcessorException {
        List controllerWrappers = (List)context.getRegistryInfo(PROCESS_CONTROLLERS);
        if (ObjectUtils.isEmpty((Object)controllerWrappers)) {
            return;
        }
        for (ControllerWrapper controllerWrapper : controllerWrappers) {
            this.unregister(controllerWrapper);
        }
        controllerWrappers.clear();
    }

    @Override
    public ProcessorContext.RunMode runMode() {
        return ProcessorContext.RunMode.PLUGIN;
    }

    private void unregister(ControllerWrapper controllerBeanWrapper) {
        Set<RequestMappingInfo> requestMappingInfoSet = controllerBeanWrapper.getRequestMappingInfo();
        if (requestMappingInfoSet != null && !requestMappingInfoSet.isEmpty()) {
            for (RequestMappingInfo requestMappingInfo : requestMappingInfoSet) {
                this.requestMappingHandlerMapping.unregisterMapping((Object)requestMappingInfo);
            }
        }
        if (this.handlerAdapter != null) {
            Class<?> beanClass = controllerBeanWrapper.getBeanClass();
            DestroyUtils.destroyValue(this.handlerAdapter, "sessionAttributesHandlerCache", beanClass);
            DestroyUtils.destroyValue(this.handlerAdapter, "initBinderCache", beanClass);
            DestroyUtils.destroyValue(this.handlerAdapter, "modelAttributeCache", beanClass);
        }
    }

    private static class RegisterMappingInfo {
        private final Object handler;
        private final Method method;
        private final RequestMappingInfo requestMappingInfo;

        public RegisterMappingInfo(Object handler, Method method, RequestMappingInfo requestMappingInfo) {
            this.handler = handler;
            this.method = method;
            this.requestMappingInfo = requestMappingInfo;
        }

        public Object getHandler() {
            return this.handler;
        }

        public Method getMethod() {
            return this.method;
        }

        public RequestMappingInfo getRequestMappingInfo() {
            return this.requestMappingInfo;
        }
    }

    private static class PluginRequestMappingHandlerMapping
    extends RequestMappingHandlerMapping {
        private final List<RegisterMappingInfo> registerMappingInfo = new ArrayList<RegisterMappingInfo>();

        public PluginRequestMappingHandlerMapping() {
            this(null);
        }

        public PluginRequestMappingHandlerMapping(String pathPrefix) {
            if (!ObjectUtils.isEmpty((CharSequence)pathPrefix)) {
                HashMap<String, Predicate<Class>> prefixes = new HashMap<String, Predicate<Class>>();
                prefixes.put(pathPrefix, c -> true);
                this.setPathPrefixes(prefixes);
            }
        }

        public void registerHandler(Object handler) {
            this.detectHandlerMethods(handler);
        }

        protected void registerHandlerMethod(Object handler, Method method, RequestMappingInfo mapping) {
            super.registerHandlerMethod(handler, method, mapping);
            this.registerMappingInfo.add(new RegisterMappingInfo(handler, method, mapping));
        }

        public List<RegisterMappingInfo> getAndClear() {
            ArrayList<RegisterMappingInfo> registerMappingInfo = new ArrayList<RegisterMappingInfo>(this.registerMappingInfo);
            this.registerMappingInfo.clear();
            return registerMappingInfo;
        }
    }

    static class ControllerWrapper {
        private String beanName;
        private Class<?> beanClass;
        private Set<RequestMappingInfo> requestMappingInfo;

        public String getBeanName() {
            return this.beanName;
        }

        public Class<?> getBeanClass() {
            return this.beanClass;
        }

        public Set<RequestMappingInfo> getRequestMappingInfo() {
            return this.requestMappingInfo;
        }

        public void setBeanName(String beanName) {
            this.beanName = beanName;
        }

        public void setBeanClass(Class<?> beanClass) {
            this.beanClass = beanClass;
        }

        public void setRequestMappingInfo(Set<RequestMappingInfo> requestMappingInfo) {
            this.requestMappingInfo = requestMappingInfo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ControllerWrapper)) {
                return false;
            }
            ControllerWrapper other = (ControllerWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$beanName = this.getBeanName();
            String other$beanName = other.getBeanName();
            if (this$beanName == null ? other$beanName != null : !this$beanName.equals(other$beanName)) {
                return false;
            }
            Class<?> this$beanClass = this.getBeanClass();
            Class<?> other$beanClass = other.getBeanClass();
            if (this$beanClass == null ? other$beanClass != null : !this$beanClass.equals(other$beanClass)) {
                return false;
            }
            Set<RequestMappingInfo> this$requestMappingInfo = this.getRequestMappingInfo();
            Set<RequestMappingInfo> other$requestMappingInfo = other.getRequestMappingInfo();
            return !(this$requestMappingInfo == null ? other$requestMappingInfo != null : !((Object)this$requestMappingInfo).equals(other$requestMappingInfo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ControllerWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $beanName = this.getBeanName();
            result = result * 59 + ($beanName == null ? 43 : $beanName.hashCode());
            Class<?> $beanClass = this.getBeanClass();
            result = result * 59 + ($beanClass == null ? 43 : $beanClass.hashCode());
            Set<RequestMappingInfo> $requestMappingInfo = this.getRequestMappingInfo();
            result = result * 59 + ($requestMappingInfo == null ? 43 : ((Object)$requestMappingInfo).hashCode());
            return result;
        }

        public String toString() {
            return "PluginControllerProcessor.ControllerWrapper(beanName=" + this.getBeanName() + ", beanClass=" + this.getBeanClass() + ", requestMappingInfo=" + this.getRequestMappingInfo() + ")";
        }
    }

    private static class ControllerPostProcessor
    implements BeanPostProcessor {
        private static final Logger LOG = LoggerFactory.getLogger(ControllerPostProcessor.class);
        private final ProcessorContext processorContext;

        private ControllerPostProcessor(ProcessorContext processorContext) {
            this.processorContext = processorContext;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            Class<?> aClass = bean.getClass();
            RequestMapping requestMapping = AnnotationUtils.findAnnotation(aClass, RequestMapping.class);
            boolean isController = AnnotationUtils.existOr(aClass, new Class[]{Controller.class, RestController.class});
            if (requestMapping != null && isController) {
                this.addControllerWrapper(beanName, aClass);
            }
            return bean;
        }

        private void addControllerWrapper(String beanName, Class<?> aClass) {
            ArrayList<ControllerWrapper> controllerWrappers = (ArrayList<ControllerWrapper>)this.processorContext.getRegistryInfo(PluginControllerProcessor.PROCESS_CONTROLLERS);
            if (controllerWrappers == null) {
                controllerWrappers = new ArrayList<ControllerWrapper>();
                this.processorContext.addRegistryInfo(PluginControllerProcessor.PROCESS_CONTROLLERS, controllerWrappers);
            }
            ControllerWrapper controllerWrapper = new ControllerWrapper();
            controllerWrapper.setBeanName(beanName);
            controllerWrapper.setBeanClass(aClass);
            controllerWrappers.add(controllerWrapper);
        }
    }
}

