/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap.processor.web;

import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.bootstrap.processor.ProcessorException;
import com.gitee.starblues.bootstrap.processor.SpringPluginProcessor;
import com.gitee.starblues.bootstrap.processor.interceptor.PluginInterceptorRegister;
import com.gitee.starblues.bootstrap.processor.interceptor.PluginInterceptorRegistry;
import com.gitee.starblues.bootstrap.utils.SpringBeanUtils;
import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.spring.MainApplicationContext;
import com.gitee.starblues.utils.ClassUtils;
import com.gitee.starblues.utils.ObjectUtils;
import com.gitee.starblues.utils.PluginConfigUtils;
import com.gitee.starblues.utils.SpringBeanCustomUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.handler.WebRequestHandlerInterceptorAdapter;

public class PluginInterceptorsProcessor
implements SpringPluginProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String INTERCEPTORS = "pluginHandlerInterceptors";
    private List<AbstractHandlerMapping> handlerMappings;

    @Override
    public void initialize(ProcessorContext context) throws ProcessorException {
        MainApplicationContext applicationContext = context.getMainApplicationContext();
        this.handlerMappings = SpringBeanCustomUtils.getBeans((com.gitee.starblues.spring.ApplicationContext)applicationContext, AbstractHandlerMapping.class);
        if (this.handlerMappings.isEmpty()) {
            this.logger.warn("Not found AbstractHandlerMapping, Plugin interceptor can't use");
        }
    }

    @Override
    public void refreshAfter(ProcessorContext context) throws ProcessorException {
        if (this.handlerMappings.isEmpty()) {
            return;
        }
        List<PluginInterceptorRegister> interceptorRegisters = SpringBeanUtils.getBeans((ApplicationContext)context.getApplicationContext(), PluginInterceptorRegister.class);
        HashMap<AbstractHandlerMapping, List<HandlerInterceptor>> handlerInterceptorMap = new HashMap<AbstractHandlerMapping, List<HandlerInterceptor>>();
        for (AbstractHandlerMapping handlerMapping : this.handlerMappings) {
            List<HandlerInterceptor> adaptedInterceptors = this.getAdaptedInterceptors(handlerMapping);
            if (ObjectUtils.isEmpty(adaptedInterceptors)) continue;
            handlerInterceptorMap.put(handlerMapping, adaptedInterceptors);
        }
        if (handlerInterceptorMap.isEmpty()) {
            this.logger.debug("handlerInterceptorMap is empty");
            return;
        }
        IntegrationConfiguration configuration = context.getConfiguration();
        String pluginId = context.getPluginDescriptor().getPluginId();
        String pluginRestPrefix = PluginConfigUtils.getPluginRestPrefix((IntegrationConfiguration)configuration, (String)pluginId);
        ArrayList<HandlerInterceptor> storeInterceptors = new ArrayList<HandlerInterceptor>();
        for (PluginInterceptorRegister interceptorRegister : interceptorRegisters) {
            PluginInterceptorRegistry interceptorRegistry = new PluginInterceptorRegistry(pluginRestPrefix);
            interceptorRegister.registry(interceptorRegistry);
            List<Object> registryInterceptors = interceptorRegistry.getInterceptors();
            if (registryInterceptors == null || registryInterceptors.isEmpty()) continue;
            for (Object interceptor : registryInterceptors) {
                HandlerInterceptor handlerInterceptor = this.adaptInterceptor(interceptor);
                for (List value : handlerInterceptorMap.values()) {
                    value.add(handlerInterceptor);
                }
                storeInterceptors.add(handlerInterceptor);
            }
        }
        context.addRegistryInfo(INTERCEPTORS, storeInterceptors);
    }

    @Override
    public void close(ProcessorContext context) throws ProcessorException {
        if (this.handlerMappings.isEmpty()) {
            return;
        }
        List storeInterceptors = (List)context.getRegistryInfo(INTERCEPTORS);
        if (ObjectUtils.isEmpty((Object)storeInterceptors)) {
            return;
        }
        for (HandlerInterceptor storeInterceptor : storeInterceptors) {
            for (AbstractHandlerMapping handlerMapping : this.handlerMappings) {
                List<HandlerInterceptor> adaptedInterceptors = this.getAdaptedInterceptors(handlerMapping);
                if (ObjectUtils.isEmpty(adaptedInterceptors)) continue;
                adaptedInterceptors.remove(storeInterceptor);
            }
        }
    }

    @Override
    public ProcessorContext.RunMode runMode() {
        return ProcessorContext.RunMode.PLUGIN;
    }

    private List<HandlerInterceptor> getAdaptedInterceptors(AbstractHandlerMapping handlerMapping) {
        try {
            return (List)ClassUtils.getReflectionField((Object)handlerMapping, (String)"adaptedInterceptors", List.class);
        }
        catch (IllegalAccessException e) {
            this.logger.error("Can't get 'adaptedInterceptors' from AbstractHandlerMapping, so You can't use HandlerInterceptor. {} ", (Object)e.getMessage());
            return null;
        }
    }

    private HandlerInterceptor adaptInterceptor(Object interceptor) {
        if (interceptor instanceof HandlerInterceptor) {
            return (HandlerInterceptor)interceptor;
        }
        if (interceptor instanceof WebRequestInterceptor) {
            return new WebRequestHandlerInterceptorAdapter((WebRequestInterceptor)interceptor);
        }
        throw new IllegalArgumentException("Interceptor type not supported: " + interceptor.getClass().getName());
    }
}

