/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap.processor.web;

import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.bootstrap.processor.ProcessorException;
import com.gitee.starblues.bootstrap.processor.SpringPluginProcessor;
import com.gitee.starblues.utils.ObjectUtils;
import java.util.HashSet;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class PluginStaticResourceProcessor
implements SpringPluginProcessor {
    private static final String STATIC_LOCATIONS = "spring.resources.static-locations";

    @Override
    public void refreshBefore(ProcessorContext context) throws ProcessorException {
        GenericApplicationContext applicationContext = context.getApplicationContext();
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        String property = environment.getProperty(STATIC_LOCATIONS);
        if (ObjectUtils.isEmpty((CharSequence)property)) {
            return;
        }
        String[] staticLocations = property.split(",");
        if (ObjectUtils.isEmpty((Object)staticLocations)) {
            return;
        }
        HashSet<String> staticLocationsSet = new HashSet<String>(staticLocations.length);
        for (String staticLocation : staticLocations) {
            if (ObjectUtils.isEmpty((CharSequence)staticLocation)) continue;
            staticLocationsSet.add(staticLocation);
        }
        context.getWebConfig().setResourceLocations(staticLocationsSet);
    }

    @Override
    public ProcessorContext.RunMode runMode() {
        return ProcessorContext.RunMode.PLUGIN;
    }
}

