/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap;

import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.core.descriptor.InsidePluginDescriptor;
import com.gitee.starblues.core.descriptor.PluginDescriptor;
import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.loader.launcher.DevelopmentModeSetting;
import com.gitee.starblues.spring.MainApplicationContext;
import com.gitee.starblues.utils.Assert;
import com.gitee.starblues.utils.FilesUtils;
import com.gitee.starblues.utils.MsgUtils;
import com.gitee.starblues.utils.ObjectUtils;
import com.gitee.starblues.utils.PluginFileUtils;
import com.gitee.starblues.utils.StringUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.LiveBeansView;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class ConfigurePluginEnvironment {
    private final Logger logger = LoggerFactory.getLogger(ConfigurePluginEnvironment.class);
    private static final String PLUGIN_PROPERTY_NAME = "pluginPropertySources";
    private static final String SPRING_CONFIG_NAME = "spring.config.name";
    private static final String SPRING_CONFIG_LOCATION = "spring.config.location";
    private static final String SPRING_JMX_UNIQUE_NAMES = "spring.jmx.unique-names";
    private static final String SPRING_ADMIM_ENABLED = "spring.application.admin.enabled";
    private static final String SPRING_ADMIN_JMX_NAME = "spring.application.admin.jmx-name";
    private static final String SPRING_ADMIN_JMX_VALUE = "org.springframework.boot:type=Admin,name=";
    public static final String REGISTER_SHUTDOWN_HOOK_PROPERTY = "logging.register-shutdown-hook";
    public static final String MBEAN_DOMAIN_PROPERTY_NAME = "spring.liveBeansView.mbeanDomain";
    private final ProcessorContext processorContext;
    private final InsidePluginDescriptor pluginDescriptor;

    public ConfigurePluginEnvironment(ProcessorContext processorContext) {
        this.processorContext = (ProcessorContext)Assert.isNotNull((Object)processorContext, (String)"processorContext \u4e0d\u80fd\u4e3a\u7a7a");
        this.pluginDescriptor = (InsidePluginDescriptor)Assert.isNotNull((Object)processorContext.getPluginDescriptor(), (String)"pluginDescriptor \u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void configureEnvironment(ConfigurableEnvironment environment, String[] args) {
        String configFileLocation;
        HashMap<String, Object> env = new HashMap<String, Object>();
        String pluginId = this.pluginDescriptor.getPluginId();
        String configFileName = this.pluginDescriptor.getConfigFileName();
        if (!ObjectUtils.isEmpty((CharSequence)configFileName)) {
            env.put(SPRING_CONFIG_NAME, PluginFileUtils.getFileName((String)configFileName));
        }
        if (!ObjectUtils.isEmpty((CharSequence)(configFileLocation = this.pluginDescriptor.getConfigFileLocation()))) {
            env.put(SPRING_CONFIG_LOCATION, this.getConfigFileLocation(configFileLocation));
        }
        env.put("plugin.enableStarter", false);
        env.put(SPRING_JMX_UNIQUE_NAMES, true);
        env.put(SPRING_ADMIM_ENABLED, false);
        env.put(SPRING_ADMIN_JMX_NAME, SPRING_ADMIN_JMX_VALUE + pluginId);
        env.put(REGISTER_SHUTDOWN_HOOK_PROPERTY, false);
        env.put(MBEAN_DOMAIN_PROPERTY_NAME, pluginId);
        try {
            Method method = LiveBeansView.class.getDeclaredMethod("registerApplicationContext", ConfigurableApplicationContext.class);
            method.setAccessible(true);
            method.invoke(null, this.processorContext.getApplicationContext());
        }
        catch (Exception ex) {
            this.logger.error("LiveBeansView.registerApplicationContext\u5931\u8d25. {}", (Object)ex.getMessage(), (Object)ex);
        }
        if (DevelopmentModeSetting.coexist()) {
            env.put("plugin.enableStarter", false);
        }
        this.configProfiles(environment);
        environment.getPropertySources().addFirst((PropertySource)new MapPropertySource(PLUGIN_PROPERTY_NAME, env));
    }

    public void logProfiles(ConfigurableEnvironment environment) {
        IntegrationConfiguration configuration = this.processorContext.getConfiguration();
        String fromMainMsg = configuration.pluginFollowProfile() != false ? " from main" : " ";
        String[] activeProfiles = environment.getActiveProfiles();
        if (activeProfiles.length > 0) {
            this.logger.info("Plugin[{}] following profiles are active{}: {}", new Object[]{MsgUtils.getPluginUnique((PluginDescriptor)this.pluginDescriptor), fromMainMsg, StringUtils.toStrByArray((String[])activeProfiles)});
        } else {
            this.logger.info("Plugin[{}]  No active profile set, falling back to default profiles{}: {}", new Object[]{MsgUtils.getPluginUnique((PluginDescriptor)this.pluginDescriptor), fromMainMsg, StringUtils.toStrByArray((String[])environment.getDefaultProfiles())});
        }
    }

    private void configProfiles(ConfigurableEnvironment environment) {
        IntegrationConfiguration configuration = this.processorContext.getConfiguration();
        if (!configuration.pluginFollowProfile().booleanValue()) {
            return;
        }
        MainApplicationContext mainApplicationContext = this.processorContext.getMainApplicationContext();
        String[] mainActiveProfiles = mainApplicationContext.getActiveProfiles();
        if (mainActiveProfiles.length > 0) {
            environment.setActiveProfiles(mainActiveProfiles);
        } else {
            this.logger.info("Plugin[{}]  No active profile set, falling back to default profiles: {}", (Object)MsgUtils.getPluginUnique((PluginDescriptor)this.pluginDescriptor), (Object)StringUtils.toStrByArray((String[])environment.getDefaultProfiles()));
        }
    }

    private String getConfigFileLocation(String configFileLocation) {
        String path = FilesUtils.resolveRelativePath((String)new File("").getAbsolutePath(), (String)configFileLocation);
        if (path.endsWith("/") || path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separator;
    }
}

