/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap;

import com.gitee.starblues.bootstrap.AutowiredTypeDefinerConfig;
import com.gitee.starblues.bootstrap.AutowiredTypeResolver;
import com.gitee.starblues.bootstrap.annotation.AutowiredType;
import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.bootstrap.realize.AutowiredTypeDefiner;
import com.gitee.starblues.utils.UrlUtils;
import java.util.Collections;
import java.util.Set;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class DefaultAutowiredTypeResolver
implements AutowiredTypeResolver {
    private final Set<AutowiredTypeDefiner.ClassDefiner> classDefiners;
    private final PathMatcher pathMatcher = new AntPathMatcher();

    public DefaultAutowiredTypeResolver(ProcessorContext processorContext) {
        AutowiredTypeDefiner autowiredTypeDefiner = processorContext.getSpringPluginBootstrap().autowiredTypeDefiner();
        if (autowiredTypeDefiner != null) {
            AutowiredTypeDefinerConfig definerConfig = new AutowiredTypeDefinerConfig();
            autowiredTypeDefiner.config(definerConfig);
            this.classDefiners = definerConfig.getClassDefiners();
        } else {
            this.classDefiners = Collections.emptySet();
        }
    }

    @Override
    public AutowiredType.Type resolve(DependencyDescriptor descriptor) {
        String name = descriptor.getDependencyType().getName();
        String classNamePath = UrlUtils.formatMatchUrl((String)name);
        for (AutowiredTypeDefiner.ClassDefiner classDefiner : this.classDefiners) {
            Set<String> classNamePatterns = classDefiner.getClassNamePatterns();
            for (String classNamePattern : classNamePatterns) {
                if (!this.pathMatcher.match(classNamePattern, classNamePath)) continue;
                return classDefiner.getAutowiredType();
            }
        }
        AutowiredType autowiredType = (AutowiredType)descriptor.getAnnotation(AutowiredType.class);
        if (autowiredType != null) {
            return autowiredType.value();
        }
        return AutowiredType.Type.PLUGIN;
    }
}

