/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap;

import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.core.descriptor.InsidePluginDescriptor;
import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.spring.SpringBeanFactory;
import com.gitee.starblues.spring.environment.EnvironmentProvider;

public abstract class PluginContextHolder {
    private static volatile Boolean INITIALIZED = false;
    private static ProcessorContext processorContext;
    private static ClassLoader pluginClassLoader;
    private static InsidePluginDescriptor pluginDescriptor;
    private static IntegrationConfiguration configuration;
    private static Boolean mainIsWebEnv;
    private static SpringBeanFactory mainSpringBeanFactory;

    private PluginContextHolder() {
    }

    static void initialize(ProcessorContext processorContext) {
        if (INITIALIZED.booleanValue()) {
            return;
        }
        PluginContextHolder.processorContext = processorContext;
        pluginClassLoader = processorContext.getClassLoader();
        pluginDescriptor = processorContext.getPluginDescriptor();
        configuration = processorContext.getConfiguration();
        mainIsWebEnv = processorContext.getMainApplicationContext().isWebEnvironment();
        mainSpringBeanFactory = processorContext.getMainBeanFactory();
        INITIALIZED = true;
    }

    public static EnvironmentProvider getEnvironmentProvider() {
        PluginContextHolder.check();
        return processorContext.getMainApplicationContext().getEnvironmentProvider();
    }

    public static IntegrationConfiguration getConfiguration() {
        PluginContextHolder.check();
        return configuration;
    }

    public static SpringBeanFactory getMainSpringBeanFactory() {
        PluginContextHolder.check();
        return mainSpringBeanFactory;
    }

    public static Boolean getMainIsWebEnv() {
        PluginContextHolder.check();
        return mainIsWebEnv;
    }

    public static ClassLoader getPluginClassLoader() {
        PluginContextHolder.check();
        return pluginClassLoader;
    }

    public static InsidePluginDescriptor getPluginDescriptor() {
        PluginContextHolder.check();
        return pluginDescriptor;
    }

    private static void check() {
        if (!INITIALIZED.booleanValue()) {
            throw new IllegalStateException("PluginContextHolder \u672a\u521d\u59cb\u5316");
        }
    }
}

