/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap;

import com.gitee.starblues.bootstrap.ConfigurePluginEnvironment;
import com.gitee.starblues.bootstrap.PluginContextHolder;
import com.gitee.starblues.bootstrap.PluginSpringApplication;
import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.bootstrap.processor.SpringPluginProcessor;
import com.gitee.starblues.bootstrap.processor.oneself.ConfigureMainPluginEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class PluginOneselfSpringApplication
extends SpringApplication {
    private final Logger logger = LoggerFactory.getLogger(PluginSpringApplication.class);
    protected final SpringPluginProcessor pluginProcessor;
    protected final ProcessorContext processorContext;
    private final ConfigurePluginEnvironment configurePluginEnvironment;
    private final GenericApplicationContext applicationContext;

    public PluginOneselfSpringApplication(SpringPluginProcessor pluginProcessor, ProcessorContext processorContext, Class<?> ... primarySources) {
        super((Class[])primarySources);
        this.pluginProcessor = pluginProcessor;
        this.processorContext = processorContext;
        this.configurePluginEnvironment = new ConfigurePluginEnvironment(processorContext);
        this.applicationContext = this.getApplicationContext();
    }

    protected GenericApplicationContext getApplicationContext() {
        return (GenericApplicationContext)super.createApplicationContext();
    }

    protected void configureEnvironment(ConfigurableEnvironment environment, String[] args) {
        super.configureEnvironment(environment, args);
        this.configurePluginEnvironment.configureEnvironment(environment, args);
        new ConfigureMainPluginEnvironment(this.processorContext).configureEnvironment(environment, args);
    }

    protected void bindToSpringApplication(ConfigurableEnvironment environment) {
        super.bindToSpringApplication(environment);
        this.configurePluginEnvironment.logProfiles(environment);
    }

    protected ConfigurableApplicationContext createApplicationContext() {
        return this.applicationContext;
    }

    public ConfigurableApplicationContext run(String ... args) {
        try {
            this.processorContext.setApplicationContext(this.applicationContext);
            PluginContextHolder.initialize(this.processorContext);
            this.pluginProcessor.initialize(this.processorContext);
            return super.run(args);
        }
        catch (Exception e) {
            this.pluginProcessor.failure(this.processorContext);
            this.logger.debug("\u542f\u52a8\u63d2\u4ef6[{}]\u5931\u8d25. {}", new Object[]{this.processorContext.getPluginDescriptor().getPluginId(), e.getMessage(), e});
            throw new RuntimeException(e);
        }
    }

    protected void refresh(ConfigurableApplicationContext applicationContext) {
        this.pluginProcessor.refreshBefore(this.processorContext);
        super.refresh(applicationContext);
        this.pluginProcessor.refreshAfter(this.processorContext);
    }
}

