/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap;

import com.gitee.starblues.bootstrap.ConfigurePluginEnvironment;
import com.gitee.starblues.bootstrap.PluginApplicationContext;
import com.gitee.starblues.bootstrap.PluginContextHolder;
import com.gitee.starblues.bootstrap.PluginListableBeanFactory;
import com.gitee.starblues.bootstrap.PluginWebApplicationContext;
import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.bootstrap.processor.SpringPluginProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.ResourceLoader;

public class PluginSpringApplication
extends SpringApplication {
    private final Logger logger = LoggerFactory.getLogger(PluginSpringApplication.class);
    protected final SpringPluginProcessor pluginProcessor;
    protected final ProcessorContext processorContext;
    private final ConfigurePluginEnvironment configurePluginEnvironment;
    private final GenericApplicationContext applicationContext;
    private final ResourceLoader resourceLoader;

    public PluginSpringApplication(SpringPluginProcessor pluginProcessor, ProcessorContext processorContext, Class<?> ... primarySources) {
        super((Class[])primarySources);
        this.pluginProcessor = pluginProcessor;
        this.processorContext = processorContext;
        this.resourceLoader = processorContext.getResourceLoader();
        this.configurePluginEnvironment = new ConfigurePluginEnvironment(processorContext);
        this.applicationContext = this.getApplicationContext();
        this.setDefaultPluginConfig();
    }

    protected GenericApplicationContext getApplicationContext() {
        DefaultListableBeanFactory beanFactory = this.getBeanFactory(this.processorContext);
        if (this.processorContext.getMainApplicationContext().isWebEnvironment()) {
            return new PluginWebApplicationContext(beanFactory, this.processorContext);
        }
        return new PluginApplicationContext(beanFactory, this.processorContext);
    }

    protected DefaultListableBeanFactory getBeanFactory(ProcessorContext processorContext) {
        return new PluginListableBeanFactory(processorContext);
    }

    public void setDefaultPluginConfig() {
        this.setResourceLoader(this.resourceLoader);
        this.setBannerMode(Banner.Mode.OFF);
        this.setEnvironment((ConfigurableEnvironment)new StandardEnvironment());
        this.setWebApplicationType(WebApplicationType.NONE);
        this.setRegisterShutdownHook(false);
        this.setLogStartupInfo(false);
    }

    protected void configureEnvironment(ConfigurableEnvironment environment, String[] args) {
        super.configureEnvironment(environment, args);
        this.configurePluginEnvironment.configureEnvironment(environment, args);
    }

    protected void bindToSpringApplication(ConfigurableEnvironment environment) {
        super.bindToSpringApplication(environment);
        this.configurePluginEnvironment.logProfiles(environment);
    }

    protected ConfigurableApplicationContext createApplicationContext() {
        return this.applicationContext;
    }

    public ConfigurableApplicationContext run(String ... args) {
        try {
            this.processorContext.setApplicationContext(this.applicationContext);
            PluginContextHolder.initialize(this.processorContext);
            this.pluginProcessor.initialize(this.processorContext);
            return super.run(args);
        }
        catch (Exception e) {
            this.pluginProcessor.failure(this.processorContext);
            this.logger.debug("\u542f\u52a8\u63d2\u4ef6[{}]\u5931\u8d25. {}", new Object[]{this.processorContext.getPluginDescriptor().getPluginId(), e.getMessage(), e});
            throw new RuntimeException(e);
        }
    }

    protected void refresh(ConfigurableApplicationContext applicationContext) {
        this.pluginProcessor.refreshBefore(this.processorContext);
        super.refresh(applicationContext);
        this.pluginProcessor.refreshAfter(this.processorContext);
    }
}

