/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap;

import com.gitee.starblues.bootstrap.PluginApplicationContext;
import com.gitee.starblues.bootstrap.listener.PluginApplicationWebEventListener;
import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.spring.environment.EnvironmentProvider;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;

public class PluginWebApplicationContext
extends PluginApplicationContext
implements WebServerApplicationContext {
    private final WebServer webServer;
    private final String serverNamespace;

    public PluginWebApplicationContext(DefaultListableBeanFactory beanFactory, ProcessorContext processorContext) {
        super(beanFactory, processorContext);
        this.webServer = new PluginSimulationWebServer(processorContext);
        this.serverNamespace = processorContext.getPluginDescriptor().getPluginId();
        this.addApplicationListener(new PluginApplicationWebEventListener(this));
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    public String getServerNamespace() {
        return this.serverNamespace;
    }

    public static class InvalidWebServerException
    extends WebServerException {
        public InvalidWebServerException() {
            super("Invalid operation", null);
        }
    }

    public static class PluginSimulationWebServer
    implements WebServer {
        private final int port;

        public PluginSimulationWebServer(ProcessorContext processorContext) {
            EnvironmentProvider provider = processorContext.getMainApplicationContext().getEnvironmentProvider();
            Integer port = provider.getInteger("server.port");
            this.port = port == null ? -1 : port;
        }

        public void start() throws WebServerException {
            throw new InvalidWebServerException();
        }

        public void stop() throws WebServerException {
            throw new InvalidWebServerException();
        }

        public int getPort() {
            return this.port;
        }
    }
}

