/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap.listener;

import com.gitee.starblues.bootstrap.PluginWebApplicationContext;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.ResolvableType;

public class PluginApplicationWebEventListener
implements ApplicationListener<ApplicationEvent> {
    private final PluginWebApplicationContext applicationContext;

    public PluginApplicationWebEventListener(PluginWebApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationReadyEvent) {
            this.callWebServerInitializedEvent();
        }
    }

    protected void callWebServerInitializedEvent() {
        String[] beanNamesForType = this.applicationContext.getBeanNamesForType(ResolvableType.forClassWithGenerics(ApplicationListener.class, (Class[])new Class[]{WebServerInitializedEvent.class}));
        PluginWebServerInitializedEvent pluginWebServerInitializedEvent = new PluginWebServerInitializedEvent(this.applicationContext);
        for (String beanName : beanNamesForType) {
            try {
                ApplicationListener applicationListener = (ApplicationListener)this.applicationContext.getBean(beanName);
                applicationListener.onApplicationEvent((ApplicationEvent)pluginWebServerInitializedEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class PluginWebServerInitializedEvent
    extends WebServerInitializedEvent {
        private final PluginWebApplicationContext pluginWebApplicationContext;

        protected PluginWebServerInitializedEvent(PluginWebApplicationContext pluginWebApplicationContext) {
            super(pluginWebApplicationContext.getWebServer());
            this.pluginWebApplicationContext = pluginWebApplicationContext;
        }

        public WebServerApplicationContext getApplicationContext() {
            return this.pluginWebApplicationContext;
        }
    }
}

