/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap.processor.web;

import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.bootstrap.processor.ProcessorException;
import com.gitee.starblues.bootstrap.processor.SpringPluginProcessor;
import com.gitee.starblues.bootstrap.processor.web.PluginControllerProcessor;
import com.gitee.starblues.spring.ApplicationContext;
import com.gitee.starblues.spring.MainApplicationContext;
import com.gitee.starblues.utils.ObjectUtils;
import com.gitee.starblues.utils.ReflectionUtils;
import com.gitee.starblues.utils.SpringBeanCustomUtils;
import io.swagger.v3.oas.models.OpenAPI;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springdoc.api.AbstractOpenApiResource;
import org.springdoc.core.OpenAPIService;

public class PluginSpringDocControllerProcessor
implements SpringPluginProcessor {
    static final String CONTROLLER_API_CLASS = "controller_api_class";
    private OpenAPIService openApiService;
    private List<Class<?>> restControllers;

    @Override
    public void initialize(ProcessorContext context) throws ProcessorException {
        try {
            MainApplicationContext mainApplicationContext = context.getMainApplicationContext();
            this.openApiService = (OpenAPIService)SpringBeanCustomUtils.getExistBean((ApplicationContext)mainApplicationContext, OpenAPIService.class);
            AbstractOpenApiResource openApiResource = (AbstractOpenApiResource)SpringBeanCustomUtils.getExistBean((ApplicationContext)mainApplicationContext, AbstractOpenApiResource.class);
            if (openApiResource == null) {
                return;
            }
            this.restControllers = (List)ReflectionUtils.getField(null, openApiResource.getClass(), (String)"ADDITIONAL_REST_CONTROLLERS", List.class);
        }
        catch (Throwable e) {
            this.restControllers = null;
        }
    }

    @Override
    public void refreshAfter(ProcessorContext context) throws ProcessorException {
        if (this.restControllers == null) {
            return;
        }
        List controllerWrappers = (List)context.getRegistryInfo("PROCESS_SUCCESS");
        if (ObjectUtils.isEmpty((Object)controllerWrappers)) {
            return;
        }
        ArrayList apiClass = new ArrayList();
        for (PluginControllerProcessor.ControllerWrapper controllerWrapper : controllerWrappers) {
            Class<?> beanClass = controllerWrapper.getBeanClass();
            this.restControllers.add(beanClass);
            apiClass.add(beanClass);
        }
        context.addRegistryInfo(CONTROLLER_API_CLASS, apiClass);
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(ProcessorContext context) throws ProcessorException {
        if (this.restControllers == null) {
            return;
        }
        List apiClass = (List)context.getRegistryInfo(CONTROLLER_API_CLASS);
        if (ObjectUtils.isEmpty((Object)apiClass)) {
            return;
        }
        try {
            for (Class controllerClass : apiClass) {
                this.restControllers.remove(controllerClass);
            }
            this.refresh();
        }
        finally {
            apiClass.clear();
        }
    }

    private void refresh() {
        if (this.openApiService != null) {
            try {
                Method setCachedOpenApiMethod = ReflectionUtils.findMethod(this.openApiService.getClass(), (String)"setCachedOpenAPI", (Class[])new Class[]{OpenAPI.class});
                if (setCachedOpenApiMethod != null) {
                    setCachedOpenApiMethod.invoke((Object)this.openApiService, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.openApiService.resetCalculatedOpenAPI();
        }
    }

    @Override
    public ProcessorContext.RunMode runMode() {
        return ProcessorContext.RunMode.PLUGIN;
    }
}

