/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap.realize;

import com.gitee.starblues.bootstrap.AutowiredTypeDefinerConfig;
import com.gitee.starblues.bootstrap.annotation.AutowiredType;
import com.gitee.starblues.utils.UrlUtils;
import java.util.HashSet;
import java.util.Set;

public interface AutowiredTypeDefiner {
    public void config(AutowiredTypeDefinerConfig var1);

    public static class ClassDefiner {
        private final AutowiredType.Type autowiredType;
        private final Set<String> classNamePatterns;

        private ClassDefiner(AutowiredType.Type autowiredType, Set<String> classNamePatterns) {
            this.autowiredType = autowiredType;
            this.classNamePatterns = classNamePatterns;
        }

        public static ClassDefiner config(AutowiredType.Type autowiredType, Class<?> ... classes) {
            if (autowiredType == null) {
                throw new IllegalArgumentException("autowiredType \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            int length = classes.length;
            if (length == 0) {
                throw new IllegalArgumentException("classes \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            HashSet<String> classNamePatterns = new HashSet<String>(length);
            for (Class<?> aClass : classes) {
                classNamePatterns.add(UrlUtils.formatMatchUrl((String)aClass.getName()));
            }
            return new ClassDefiner(autowiredType, classNamePatterns);
        }

        public static ClassDefiner config(AutowiredType.Type autowiredType, String ... classNamePatterns) {
            if (autowiredType == null) {
                throw new IllegalArgumentException("autowiredType \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            int length = classNamePatterns.length;
            if (length == 0) {
                throw new IllegalArgumentException("classNamePatterns \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            HashSet<String> classNamePatternsSet = new HashSet<String>(length);
            for (String classNamePattern : classNamePatterns) {
                classNamePatternsSet.add(UrlUtils.formatMatchUrl((String)classNamePattern));
            }
            return new ClassDefiner(autowiredType, classNamePatternsSet);
        }

        public AutowiredType.Type getAutowiredType() {
            return this.autowiredType;
        }

        public Set<String> getClassNamePatterns() {
            return this.classNamePatterns;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassDefiner)) {
                return false;
            }
            ClassDefiner other = (ClassDefiner)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AutowiredType.Type this$autowiredType = this.getAutowiredType();
            AutowiredType.Type other$autowiredType = other.getAutowiredType();
            if (this$autowiredType == null ? other$autowiredType != null : !((Object)((Object)this$autowiredType)).equals((Object)other$autowiredType)) {
                return false;
            }
            Set<String> this$classNamePatterns = this.getClassNamePatterns();
            Set<String> other$classNamePatterns = other.getClassNamePatterns();
            return !(this$classNamePatterns == null ? other$classNamePatterns != null : !((Object)this$classNamePatterns).equals(other$classNamePatterns));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClassDefiner;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AutowiredType.Type $autowiredType = this.getAutowiredType();
            result = result * 59 + ($autowiredType == null ? 43 : ((Object)((Object)$autowiredType)).hashCode());
            Set<String> $classNamePatterns = this.getClassNamePatterns();
            result = result * 59 + ($classNamePatterns == null ? 43 : ((Object)$classNamePatterns).hashCode());
            return result;
        }
    }
}

