/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap.utils;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.context.ApplicationContext;

public class SpringBeanUtils {
    public static Set<String> getBeanName(ApplicationContext applicationContext) {
        String[] beanDefinitionNames = applicationContext.getBeanDefinitionNames();
        HashSet<String> set = new HashSet<String>(beanDefinitionNames.length);
        set.addAll(Arrays.asList(beanDefinitionNames));
        return set;
    }

    public static <T> List<T> getBeans(ApplicationContext applicationContext, Class<T> aClass) {
        Map beansOfTypeMap = applicationContext.getBeansOfType(aClass);
        if (beansOfTypeMap.isEmpty()) {
            return new ArrayList();
        }
        return new ArrayList(beansOfTypeMap.values());
    }

    public static <T> T getExistBean(ApplicationContext applicationContext, Class<T> aClass) {
        String[] beanNamesForType = applicationContext.getBeanNamesForType(aClass, false, false);
        if (beanNamesForType.length > 0) {
            return (T)applicationContext.getBean(aClass);
        }
        return null;
    }

    public static <T> T getExistBean(ApplicationContext applicationContext, String beanName) {
        if (applicationContext.containsBean(beanName)) {
            Object bean = applicationContext.getBean(beanName);
            return (T)bean;
        }
        return null;
    }

    public static List<Object> getBeansWithAnnotation(ApplicationContext applicationContext, Class<? extends Annotation> annotationType) {
        Map beanMap = applicationContext.getBeansWithAnnotation(annotationType);
        return new ArrayList<Object>(beanMap.values());
    }
}

