/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.post;

import com.gitee.starblues.extension.ExtensionInitializer;
import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.post.PluginPostProcessor;
import com.gitee.starblues.factory.process.post.bean.PluginConfigurationPostProcessor;
import com.gitee.starblues.factory.process.post.bean.PluginControllerPostProcessor;
import com.gitee.starblues.factory.process.post.bean.PluginInvokePostProcessor;
import com.gitee.starblues.factory.process.post.bean.PluginOneselfStartEventProcessor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class PluginPostProcessorFactory
implements PluginPostProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<PluginPostProcessor> pluginPostProcessors = new ArrayList<PluginPostProcessor>();
    private final ApplicationContext applicationContext;

    public PluginPostProcessorFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void initialize() throws Exception {
        this.pluginPostProcessors.addAll(ExtensionInitializer.getPostProcessorExtends());
        this.pluginPostProcessors.add(new PluginConfigurationPostProcessor(this.applicationContext));
        this.pluginPostProcessors.add(new PluginInvokePostProcessor(this.applicationContext));
        this.pluginPostProcessors.add(new PluginControllerPostProcessor(this.applicationContext));
        this.pluginPostProcessors.add(new PluginOneselfStartEventProcessor(this.applicationContext));
        for (PluginPostProcessor pluginPostProcessor : this.pluginPostProcessors) {
            pluginPostProcessor.initialize();
        }
    }

    @Override
    public void registry(List<PluginRegistryInfo> pluginRegistryInfos) throws Exception {
        for (PluginPostProcessor pluginPostProcessor : this.pluginPostProcessors) {
            pluginPostProcessor.registry(pluginRegistryInfos);
        }
    }

    @Override
    public void unRegistry(List<PluginRegistryInfo> pluginRegistryInfos) throws Exception {
        for (PluginPostProcessor pluginPostProcessor : this.pluginPostProcessors) {
            pluginPostProcessor.unRegistry(pluginRegistryInfos);
        }
    }
}

