/*
 * Decompiled with CFR 0.152.
 */
package com.tiamosu.databinding.delegate;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.MainThread;
import androidx.annotation.RestrictTo;
import androidx.databinding.ViewDataBinding;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.viewbinding.ViewBinding;
import com.tiamosu.databinding.delegate.ViewBindingProperty;
import com.tiamosu.databinding.delegate.ViewBindingPropertyDelegate;
import com.tiamosu.databinding.internal.UtilsKt;
import com.tiamosu.navigation.page.FlyLifecycleObserver;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b'\u0018\u0000 \u001e*\n\b\u0000\u0010\u0001 \u0000*\u00020\u0002*\n\b\u0001\u0010\u0003 \u0001*\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005:\u0002\u001d\u001eB-\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\tH\u0017J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0011J\"\u0010\u0012\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00028\u00002\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0097\u0002\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0018J\r\u0010\u0019\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001cR\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\t0\u0007X\u0088\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00018\u0001X\u0088\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/tiamosu/databinding/delegate/LifecycleViewBindingProperty;", "R", "", "T", "Landroidx/viewbinding/ViewBinding;", "Lcom/tiamosu/databinding/delegate/ViewBindingProperty;", "viewBinder", "Lkotlin/Function1;", "onViewDestroyed", "", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "viewBinding", "Landroidx/viewbinding/ViewBinding;", "clear", "getLifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "thisRef", "(Ljava/lang/Object;)Landroidx/lifecycle/LifecycleOwner;", "getValue", "property", "Lkotlin/reflect/KProperty;", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;)Landroidx/viewbinding/ViewBinding;", "isViewInitialized", "", "(Ljava/lang/Object;)Z", "postClear", "postClear$fly_databinding_release", "runStrictModeChecks", "(Ljava/lang/Object;)V", "ClearOnDestroyLifecycleObserver", "Companion", "fly-databinding_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class LifecycleViewBindingProperty<R, T extends ViewBinding>
implements ViewBindingProperty<R, T> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<R, T> viewBinder;
    @NotNull
    private final Function1<T, Unit> onViewDestroyed;
    @Nullable
    private T viewBinding;
    @Deprecated
    @NotNull
    private static final Handler mainHandler = new Handler(Looper.getMainLooper());

    public LifecycleViewBindingProperty(@NotNull Function1<? super R, ? extends T> viewBinder, @NotNull Function1<? super T, Unit> onViewDestroyed) {
        Intrinsics.checkNotNullParameter(viewBinder, (String)"viewBinder");
        Intrinsics.checkNotNullParameter(onViewDestroyed, (String)"onViewDestroyed");
        this.viewBinder = viewBinder;
        this.onViewDestroyed = onViewDestroyed;
    }

    @NotNull
    protected abstract LifecycleOwner getLifecycleOwner(@NotNull R var1);

    @MainThread
    @NotNull
    public T getValue(@NotNull R thisRef, @NotNull KProperty<?> property) {
        ViewBinding viewBinding;
        Intrinsics.checkNotNullParameter(thisRef, (String)"thisRef");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        T t = this.viewBinding;
        if (t != null) {
            T it = t;
            boolean bl = false;
            return it;
        }
        if (!this.isViewInitialized(thisRef)) {
            throw new IllegalStateException("Host view isn't ready to create a ViewBinding instance".toString());
        }
        if (ViewBindingPropertyDelegate.INSTANCE.getStrictMode()) {
            this.runStrictModeChecks(thisRef);
        }
        Lifecycle lifecycle = this.getLifecycleOwner(thisRef).getLifecycle();
        Intrinsics.checkNotNullExpressionValue((Object)lifecycle, (String)"getLifecycleOwner(thisRef).lifecycle");
        Lifecycle lifecycle2 = lifecycle;
        if (lifecycle2.getCurrentState() == Lifecycle.State.DESTROYED) {
            this.viewBinding = null;
            Log.w((String)"ViewBindingProperty", (String)"Access to viewBinding after Lifecycle is destroyed or hasn't created yet. The instance of viewBinding will be not cached.");
            viewBinding = (ViewBinding)this.viewBinder.invoke(thisRef);
        } else {
            ViewBinding viewBinding2 = (ViewBinding)this.viewBinder.invoke(thisRef);
            lifecycle2.addObserver((LifecycleObserver)new ClearOnDestroyLifecycleObserver(this));
            this.viewBinding = viewBinding2;
            viewBinding = viewBinding2;
        }
        return (T)viewBinding;
    }

    private final void runStrictModeChecks(R thisRef) {
        Lifecycle lifecycle = this.getLifecycleOwner(thisRef).getLifecycle();
        Intrinsics.checkNotNullExpressionValue((Object)lifecycle, (String)"getLifecycleOwner(thisRef).lifecycle");
        Lifecycle lifecycle2 = lifecycle;
        if (lifecycle2.getCurrentState() == Lifecycle.State.DESTROYED) {
            throw new IllegalStateException("Access to viewBinding after Lifecycle is destroyed or hasn't created yet. The instance of viewBinding will be not cached.".toString());
        }
    }

    protected boolean isViewInitialized(@NotNull R thisRef) {
        Intrinsics.checkNotNullParameter(thisRef, (String)"thisRef");
        return true;
    }

    @Override
    @MainThread
    @CallSuper
    public void clear() {
        UtilsKt.checkMainThread();
        T viewBinding = this.viewBinding;
        this.viewBinding = null;
        if (viewBinding != null) {
            this.onViewDestroyed.invoke(viewBinding);
            ViewDataBinding viewDataBinding = viewBinding instanceof ViewDataBinding ? (ViewDataBinding)viewBinding : null;
            if (viewDataBinding != null) {
                viewDataBinding.unbind();
            }
        }
    }

    public final void postClear$fly_databinding_release() {
        if (!mainHandler.post(() -> LifecycleViewBindingProperty.postClear$lambda-1(this))) {
            this.clear();
        }
    }

    private static final void postClear$lambda-1(LifecycleViewBindingProperty this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.clear();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017R\u0016\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/tiamosu/databinding/delegate/LifecycleViewBindingProperty$ClearOnDestroyLifecycleObserver;", "Lcom/tiamosu/navigation/page/FlyLifecycleObserver;", "property", "Lcom/tiamosu/databinding/delegate/LifecycleViewBindingProperty;", "(Lcom/tiamosu/databinding/delegate/LifecycleViewBindingProperty;)V", "onDestroy", "", "owner", "Landroidx/lifecycle/LifecycleOwner;", "fly-databinding_release"})
    private static final class ClearOnDestroyLifecycleObserver
    implements FlyLifecycleObserver {
        @NotNull
        private final LifecycleViewBindingProperty<?, ?> property;

        public ClearOnDestroyLifecycleObserver(@NotNull LifecycleViewBindingProperty<?, ?> property) {
            Intrinsics.checkNotNullParameter(property, (String)"property");
            this.property = property;
        }

        @MainThread
        public void onDestroy(@NotNull LifecycleOwner owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            this.property.postClear$fly_databinding_release();
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_CREATE)
        @MainThread
        public void onCreate(@NotNull LifecycleOwner owner) {
            FlyLifecycleObserver.DefaultImpls.onCreate((FlyLifecycleObserver)this, (LifecycleOwner)owner);
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_ANY)
        @MainThread
        public void onLifecycleChanged(@NotNull LifecycleOwner owner, @NotNull Lifecycle.Event event) {
            FlyLifecycleObserver.DefaultImpls.onLifecycleChanged((FlyLifecycleObserver)this, (LifecycleOwner)owner, (Lifecycle.Event)event);
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
        @MainThread
        public void onPause(@NotNull LifecycleOwner owner) {
            FlyLifecycleObserver.DefaultImpls.onPause((FlyLifecycleObserver)this, (LifecycleOwner)owner);
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
        @MainThread
        public void onResume(@NotNull LifecycleOwner owner) {
            FlyLifecycleObserver.DefaultImpls.onResume((FlyLifecycleObserver)this, (LifecycleOwner)owner);
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
        @MainThread
        public void onStart(@NotNull LifecycleOwner owner) {
            FlyLifecycleObserver.DefaultImpls.onStart((FlyLifecycleObserver)this, (LifecycleOwner)owner);
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
        @MainThread
        public void onStop(@NotNull LifecycleOwner owner) {
            FlyLifecycleObserver.DefaultImpls.onStop((FlyLifecycleObserver)this, (LifecycleOwner)owner);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/tiamosu/databinding/delegate/LifecycleViewBindingProperty$Companion;", "", "()V", "mainHandler", "Landroid/os/Handler;", "fly-databinding_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

