/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.JdkHttp2ClientHttpRequestFactory;
import org.springframework.http.client.JdkHttp2ClientHttpResponse;

public class JdkHttp2ClientHttpRequest
extends AbstractClientHttpRequest {
    private final HttpClient client;
    private final URI uri;
    private final HttpMethod method;
    private final Duration readTimeout;
    private ByteArrayOutputStream bufferedOutput = new ByteArrayOutputStream(1024);

    public JdkHttp2ClientHttpRequest(HttpClient client, URI uri, HttpMethod method, Duration readTimeout) {
        this.client = client;
        this.uri = uri;
        this.method = method;
        this.readTimeout = readTimeout;
    }

    protected OutputStream getBodyInternal(HttpHeaders headers) throws IOException {
        return this.bufferedOutput;
    }

    protected ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
        byte[] content = this.bufferedOutput.toByteArray();
        HttpRequest request = JdkHttp2ClientHttpRequestFactory.buildRequest(headers, content, this.getURI(), this.getMethodValue(), this.readTimeout);
        try {
            HttpResponse<InputStream> response = this.client.send(request, HttpResponse.BodyHandlers.ofInputStream());
            JdkHttp2ClientHttpResponse jdkHttp2ClientHttpResponse = new JdkHttp2ClientHttpResponse(response);
            return jdkHttp2ClientHttpResponse;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        finally {
            this.bufferedOutput = new ByteArrayOutputStream(0);
        }
    }

    public String getMethodValue() {
        return this.method.name();
    }

    public URI getURI() {
        return this.uri;
    }
}

