/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.AbstractClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.StreamUtils;

public class JdkHttp2ClientHttpResponse
extends AbstractClientHttpResponse {
    private final HttpResponse<InputStream> response;
    @Nullable
    private volatile HttpHeaders headers;

    public JdkHttp2ClientHttpResponse(HttpResponse<InputStream> response) {
        this.response = response;
    }

    public int getRawStatusCode() {
        return this.response.statusCode();
    }

    public String getStatusText() {
        HttpStatus httpStatus = HttpStatus.resolve((int)this.getRawStatusCode());
        return httpStatus.getReasonPhrase();
    }

    public InputStream getBody() {
        InputStream body = this.response.body();
        return body == null ? StreamUtils.emptyInput() : body;
    }

    public HttpHeaders getHeaders() {
        HttpHeaders headers = this.headers;
        if (headers == null) {
            headers = new HttpHeaders();
            Map<String, List<String>> headerMap = this.response.headers().map();
            for (Map.Entry<String, List<String>> entry : headerMap.entrySet()) {
                headers.addAll(entry.getKey(), entry.getValue());
            }
            this.headers = headers;
        }
        return headers;
    }

    public void close() {
        InputStream body = this.response.body();
        if (body != null) {
            try {
                body.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

