/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;

public abstract class HttpClientUtil {
    private static final Set<String> DISALLOWED_HEADERS_SET;
    private static final Predicate<String> ALLOWED_HEADERS;

    public static boolean allowed(String headerName) {
        return ALLOWED_HEADERS.test(headerName);
    }

    private HttpClientUtil() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    static {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        treeSet.addAll(Set.of("connection", "content-length", "date", "expect", "from", "host", "upgrade", "via", "warning"));
        DISALLOWED_HEADERS_SET = Collections.unmodifiableSet(treeSet);
        ALLOWED_HEADERS = header -> !DISALLOWED_HEADERS_SET.contains(header);
    }
}

