package com.zzh.lib.pay;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Looper;
import android.util.Log;
import android.util.Xml;

import com.zzh.lib.pay.alipay.AlipayHelper;
import com.zzh.lib.pay.model.HPayInfo;
import com.zzh.lib.pay.model.HPayKey;
import com.zzh.lib.pay.uppay.UpPayHelper;
import com.zzh.lib.pay.wxpay.MD5;
import com.zzh.lib.pay.wxpay.WechatPayHelper;

import org.xmlpull.v1.XmlPullParser;

import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/**
 * @Date: 2022/5/23 15:30
 * @Email: zzh_hz@126.com
 * @QQ: 1299234582
 * @Author: zzh
 * @Description: PayAgent.java
 */
public class HPayAgent {

    private static final String TAG = "HPayAgent";

    private static boolean isInitAliPayKeys;
    private static boolean isInitWxPayKeys;
    private static boolean isInitUpPayKeys;

    public static final String ALIPAY_PARTNER_ID = "ALIPAY_PARTNER_ID";
    public static final String ALIPAY_SELLER_ID = "ALIPAY_SELLER_ID";
    public static final String ALIPAY_PRIVATE_KEY = "ALIPAY_PRIVATE_KEY";
    public static final String ALIPAY_PUBLIC_KEY = "ALIPAY_PUBLIC_KEY";
    public static final String ALIPAY_APP_ID = "ALIPAY_APP_ID";

    public static final String WXPAY_APP_ID = "WXPAY_APP_ID";
    public static final String WXPAY_MCH_ID = "WXPAY_MCH_ID";
    public static final String WXPAY_API_KEY = "WXPAY_API_KEY";

    public static final String UPPAY_PUBLICKEY_PM_MODULUS = "UPPAY_PUBLICKEY_PM_MODULUS";
    public static final String UPPAY_PUBLIC_EXPONENT = "UPPAY_PUBLIC_EXPONENT";
    public static final String UPPAY_PUBLIC_KEY_PRODUCT_MODULUS = "UPPAY_PUBLIC_KEY_PRODUCT_MODULUS";


    public PayType currentPayType;

    private boolean isInit;

    private static volatile HPayAgent instance;

    /*** 支付方式 */
    public enum PayType {
        /**
         * 支付宝
         */
        ALIPAY,
        /**
         * 微信
         */
        WECHAT,
        /**
         * 银联支付
         */
        UP
    }

    private AlipayHelper mAlipayHelper;
    private WechatPayHelper mWechatPayHelper;
    private UpPayHelper mUpPayHelper;

    private HPayAgent() {
    }

    public static HPayAgent getInstance() {
        if (null == instance) {
            synchronized (HPayAgent.class) {
                if (null == instance) {
                    instance = new HPayAgent();
                }
            }
        }
        return instance;
    }

    public AlipayHelper getAlipayHelper() {
        if (null == mAlipayHelper) {
            mAlipayHelper = new AlipayHelper();
        }
        return mAlipayHelper;
    }

    public WechatPayHelper getWechatPayHelper() {
        if (null == mWechatPayHelper) {
            mWechatPayHelper = new WechatPayHelper();
        }
        return mWechatPayHelper;
    }

    public UpPayHelper getUpPayHelper() {
        if (null == mUpPayHelper) {
            mUpPayHelper = new UpPayHelper();
        }
        return mUpPayHelper;
    }

    public PayType getCurrentPayType() {
        return currentPayType;
    }

    /***
     * set debug modle
     *
     * @param debug
     *            [true or false]
     */
    public void setDebug(boolean debug) {
        L.isDebug = debug;
    }

    /**
     * 设置 为正式环境或测试环境【true , false】
     */
    public void setOnlineMode(boolean isOnlineMode) {
        getAlipayHelper().setOnlineMode(isOnlineMode);
        getUpPayHelper().setOnlineMode(isOnlineMode);
        getWechatPayHelper().setOnlineMode(isOnlineMode);
    }

    /**
     * 初始化 支付组件
     *
     * @param activity Activity
     * @return boolean
     */
    public synchronized boolean initPay(Activity activity) {
        if (isInit) {
            return true;
        }

        boolean success = true;
        success &= initKeys(activity);
        success &= getWechatPayHelper().registerWechatApi(activity);

        isInit = true;
        return success;
    }

    public boolean initKeys(Context activity) {
        if (!isInitAliPayKeys) {
            /*HPayKey.ALI_PARTNER_ID = "2088231115507207";
            HPayKey.ALI_SELLER_ID = "xywhgf@163.com";
            HPayKey.ALI_PRIVATE_KEY = "MIIEpAIBAAKCAQEAujfPHPow4NVEPkaUgYeGBrN1EjaEvOU1zgD0RK8DOSF02qRxpd2SVLGGixy5xDXNaWpQ5nVctuYOxEX7yiY31wrZr/COw2Jz6PdqHKGoqkfyxZedhZyCYBGw+RF9D+sXn0/agr3OY8ytFpjB+kvFx0Tq3rzW6bxroMVT7KWHKPEghBJC1+O5Xt7SKJnIF12r6BE2GPmFaRldR78X+grQgK7zFHjPqZ4SW1XnQnM+wG9v1CyKkxmC3ChE3SfY73PgHv6+TPxLBh5kp3vD7+B4IYvmYwfiii673gOY9kWYXAZ97pOP+U5rJMA0pEuAAZS49i99q+ZSz50fXEIQAURyIQIDAQABAoIBADYJBb9p1g8Xs3LCtksT0U9Wea0sRr4tYLyDSF45zpygWbEsMJIpxlFvJhRt5HXMCuwA3rLQ8XNdNIG9sP+KsX9j9aD5E+QcSHgcex0Nx8yJjifKA/qGXMqVt52+dmTNGhCvcj+n5iDNfphlATypCh31oJW7hD1U4IJJYD32Fk9Jkig4uYM24t2DD2fQIaV868OWu0U9ravJX0jnhKl26FV/4jOKj129kXUmQE79L/P3wQicilyDdu1A9Yia4rPXys4/owGtJeb66EePbpHgBQm1govt3I4zGhqhrhsfpsZjE+CfIoNep6AEtuz5thHlVujW0pDLilv2HHtrQJenaMECgYEA2l+B+Pnxx6km2e8WxJK5rqFIOc2RQow3j0p80YmEYdI32UU6v05Q7DVL3TDdtoZ/ZCQ4TBDjxkcp6eUeqctLX+l+mYBXLMPnrOQRDaZ3NOsGPQthcojHsrZXFgRbBtp3xVPSepXOnSgI71g7WJw1ByCnd5hsuAFRighxxU03StkCgYEA2k3uzmk9o03LuA4Cjnzdlpx2Njhp4LUu3x9K5X0yxV51tHALgNMY7bwSt0bAO7VRSuKCHePuJ7ob3bpIHPjAT/0k6Sj9YN14KjHHfOi8Nt9Pa82mPhbB23u0TzAIE+Gs89AWzjJcq3nWV0XICg4OXK/UMpzBYU3uo1/MTphSBIkCgYBdekDS6Xt8MoZ1CAnA/+YIQPX/+GVUDV3DMumXcLyAe1J46U+qkMXHN1FQUBi4h36EyZRny1sVh2UDwJaNrH6JghQ1dWDbwsirk71REI860diLzRFby/1gHPnObPLiTiazC5yv6OzXDUo12pkc51EzyeCmK1NuuPHEmrTI9rLSkQKBgQCW3/HB+n49FRFM3XHq5GWJKA2TH54dTVtdnZT30nV6bvROhnmMyVibRbZxsJY/LetHJBDlc5gvILMNpScdztWq8rvF4Sxs++OG1eyXaYpbKi8LxI+2rafBd1eAuyN6CiisQQ7h53Cgmo4GtxWvzVMjv+maKTiFdYUOqLDdSOy2cQKBgQCi1Im1Y5jlg+SPyTDKkZw90hnXoch6MK5zi0vGqNe2JyLhNgKT5gZBpvTAzhi6U8fahIra66/BRu9yFNg/dw0Tizpof58E6NInMxoC3gSkFBEudtu2J83FdRiQLSYenJf41ZrLEpllXP+Z3AjJIX7DRlw7E+Atvtu+8SpyR9HgUA==";
            HPayKey.ALI_PAY_PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAujfPHPow4NVEPkaUgYeGBrN1EjaEvOU1zgD0RK8DOSF02";*/
            HPayKey.ALI_PARTNER_ID = getMetaData(activity, ALIPAY_PARTNER_ID);
            HPayKey.ALI_APP_ID = getMetaData(activity, ALIPAY_APP_ID);
            HPayKey.ALI_SELLER_ID = getMetaData(activity, ALIPAY_SELLER_ID);
            HPayKey.ALI_PRIVATE_KEY = getMetaData(activity, ALIPAY_PRIVATE_KEY);
            HPayKey.ALI_PAY_PUBLIC_KEY = getMetaData(activity, ALIPAY_PUBLIC_KEY);

            isInitAliPayKeys = true;
        }

        if (!isInitWxPayKeys) {
            HPayKey.WX_APP_ID = getMetaData(activity, WXPAY_APP_ID);
            HPayKey.WX_MCH_ID = getMetaData(activity, WXPAY_MCH_ID);
            HPayKey.WX_API_KEY = getMetaData(activity, WXPAY_API_KEY);
            isInitWxPayKeys = true;
        }

        if (!isInitUpPayKeys) {
            HPayKey.UP_PUBLIC_EXPONENT = getMetaData(activity, UPPAY_PUBLIC_EXPONENT);
            HPayKey.UP_PUBLIC_KEY_PM_MODULES = getMetaData(activity, UPPAY_PUBLICKEY_PM_MODULUS);
            HPayKey.UP_PUBLIC_KEY_PRODUCT_MODULES = getMetaData(activity, UPPAY_PUBLIC_KEY_PRODUCT_MODULUS);
            isInitUpPayKeys = true;

        }
        return true;
    }

    ApplicationInfo appInfo = null;

    // 在application应用<meta-data>元素。
    public String getMetaData(Context ctx, String key) {
        appInfo = null;
        String value = "";
        try {
            if (appInfo == null) {
                appInfo = ctx.getPackageManager().getApplicationInfo(ctx.getPackageName(), PackageManager.GET_META_DATA);
            }
            value = String.valueOf(appInfo.metaData.get(key));
            L.d(TAG, "meta-data :key: " + key);
            L.d(TAG, "  meta-data :value: " + value);
        } catch (PackageManager.NameNotFoundException e) {
            L.w(TAG, e.getMessage());
        }

        return value;
    }

    /**
     * 初始化 支付宝 配置参数
     *
     * @param partnerId
     * @param sellerId
     * @param privateKey
     * @param publicKey
     */
    public static boolean initAliPayKeys(String partnerId, String sellerId,
                                         String privateKey, String publicKey) {
        HPayKey.ALI_PARTNER_ID = partnerId;
        HPayKey.ALI_SELLER_ID = sellerId;
        HPayKey.ALI_PRIVATE_KEY = privateKey;
        HPayKey.ALI_PAY_PUBLIC_KEY = publicKey;
        isInitAliPayKeys = true;
        return true;
    }

    /**
     * 初始化微信支付 所需的appid ,appkey ..
     *
     * @return boolean
     */
    public boolean initWxPayKeys(String appId, String mchId, String appKey) {
        HPayKey.WX_APP_ID = appId;
        HPayKey.WX_MCH_ID = mchId;
        HPayKey.WX_API_KEY = appKey;
        isInitWxPayKeys = true;
        return true;
    }

    /**
     * 初始化 银联支付 所需的 验签 参数
     *
     * @param PublicKeyPMModulus
     * @param publicExponent
     * @param PublicKeyProductModulus
     * @return boolean
     */
    public boolean initUpPayKeys(String PublicKeyPMModulus,
                                 String publicExponent, String PublicKeyProductModulus) {
        HPayKey.UP_PUBLIC_KEY_PM_MODULES = PublicKeyPMModulus;
        HPayKey.UP_PUBLIC_KEY_PRODUCT_MODULES = PublicKeyProductModulus;
        HPayKey.UP_PUBLIC_EXPONENT = publicExponent;
        isInitUpPayKeys = true;
        return true;
    }

    /**
     * 支付宝 支付 <b>[ 同步调用 <i>即在主（ui）线程调用</i>]</b>
     *
     * @param activity : 调起支付 所在的 activity
     * @param payInfo  : 支付信息 [订单号，支付金额，商品名称，支付服务器回调地址..]
     */
    public void payOfAliPay(Activity activity, HPayInfo payInfo,
                            OnPayListener listener) {
        onPay(HPayAgent.PayType.ALIPAY, activity, payInfo, listener);
    }

    /**
     * 微信支付 <b>[ 同步调用<i> 即在主（ui）线程调用</i>]</b>
     *
     * @param activity : 调起支付 所在的 activity
     * @param payInfo  : 支付信息 [订单号，支付金额，商品名称，支付服务器回调地址..]
     */
    public void payOfWechatPay(Activity activity, HPayInfo payInfo,
                               OnPayListener listener) {
        onPay(HPayAgent.PayType.WECHAT, activity, payInfo, listener);
    }

    /**
     * 银联支付<b>[ 同步调用<i> 即在主（ui）线程调用</i>]</b>
     *
     * @param activity Activity
     * @param payInfo  【orderNo,tn 银行流水号】
     * @param listener OnPayListener
     */
    public void payOfUpPay(Activity activity, HPayInfo payInfo,
                           OnPayListener listener) {
        onPay(HPayAgent.PayType.UP, activity, payInfo, listener);
    }

    /**
     * 调起 支付 <b>[ 同步调用<i>即在主（ui）线程调用</i>]</b>
     *
     * @param payType
     * @param activity 调起支付 所在的 activity
     * @param payInfo  支付信息 [订单号，支付金额，商品名称，支付服务器回调地址..]
     *                 <p>
     *                 <i>PayInfo -> price
     *                 微信:交易金额默认为人民币交易，接口中参数支付金额单位为【分】，参数值不能带小数。</i>
     *                 </p>
     * @param listener 支付回调
     */
    public void onPay(PayType payType, Activity activity, HPayInfo payInfo,
                      OnPayListener listener) {

        currentPayType = payType;

        if (!isInit) {
            initPay(activity);
        }

        if (null == payInfo) {
            throw new IllegalArgumentException(" payinfo  is null!");
        }

        if (null == activity) {
            throw new IllegalArgumentException(" Activity  is null!");
        }

        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalArgumentException(Thread.currentThread().getName()
                    + "'. " + "onPay methods must be called on the UI thread. ");
        }

        switch (payType) {
            case ALIPAY:
                getAlipayHelper().pay(activity, payInfo, listener);
                break;

            case WECHAT:
                getWechatPayHelper().pay(activity, payInfo, listener);
                break;
            case UP:
                getUpPayHelper().pay(activity, payInfo, listener);
                break;
            default:
                throw new IllegalArgumentException(
                        " payType is ALIPAY or WXPAY ");
        }

    }

    /**
     * 获取随机字符串
     *
     * @return 字符串
     */
    public String genNonceStr() {
        Random random = new Random();
        return MD5.getMessageDigest(String.valueOf(random.nextInt(10000)).getBytes());
    }

    /**
     * 拉起支付时的签名
     *
     * @param params 需要签名的字段
     * @return 签名后的字符串
     */
    public String genAppSign(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();

        Set<String> keySet = params.keySet();
        Object[] objects = keySet.toArray();
        Arrays.sort(objects);
        L.d(TAG, Arrays.toString(objects));
        for (Object key : objects) {
            sb.append(key);
            sb.append('=');
            sb.append(params.get(key));
            sb.append('&');
        }

        sb.append("key=");
        sb.append(HPayKey.WX_API_KEY);
        L.e(TAG, " genAppSign " + sb);
        String appSign = MD5.getMessageDigest(sb.toString().getBytes()).toUpperCase(Locale.getDefault());
        L.e(TAG, " genAppSign " + appSign);
        return appSign;
    }

    public final String xmlWeChatPay(Map<String, String> map) {
        StringBuilder builder = new StringBuilder("<xml>");
        Set<String> keySet = map.keySet();



        for (String key : keySet) {
            builder.append("<").append(key).append(">").append(map.get(key)).append("</").append(key).append(">");
        }
        builder.append("</xml>");
        return builder.toString();
    }

    public final Map<String, String> decodeXml(String content) {
        try {
            Map<String, String> xml = new HashMap<String, String>();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(new StringReader(content));
            int event = parser.getEventType();
            while (event != XmlPullParser.END_DOCUMENT) {
                String nodeName = parser.getName();
                switch (event) {
                    case XmlPullParser.START_DOCUMENT:
                        break;
                    case XmlPullParser.START_TAG:
                        if ("xml".equals(nodeName) == false) {
                            //实例化student对象
                            xml.put(nodeName, parser.nextText());
                        }
                        break;
                    case XmlPullParser.END_TAG:
                        break;
                }
                event = parser.next();
            }

            return xml;
        } catch (Exception e) {
            Log.e("orion", e.toString());
        }
        return null;

    }

}
