
package com.zzh.lib.pay.model;

import java.io.Serializable;

public final class HPayInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 商品名称
     */
    private String subject;
    private String aliTimeoutExpress = "90m";

    public String getAliTimeoutExpress() {
        return aliTimeoutExpress == null ? "" : aliTimeoutExpress;
    }

    public void setAliTimeoutExpress(String aliTimeoutExpress) {
        this.aliTimeoutExpress = aliTimeoutExpress;
    }

    /**
     * 商品详细信息  商品的标题/交易标题/订单标题/订单关键字等。该参数最长为128个汉字
     */
    private String body;

    /**
     * 商品价格
     */
    private String price;

    /**
     * 商品订单号
     */
    private String orderNo;

    /**
     * 支付通知地址
     */
    private String aliAppId;
    private String notifyUrl;


    /** 以下是微信支付相关参数 */
    /**
     * AppId
     */
    private String appId;
    /**
     * 商户id partnerId
     */
    private String partnerId;
    /**
     * packageValue
     */
    private String packageValue;
    /**
     * noncestr
     */
    private String noncestr;
    /**
     * 预付订单id
     */
    private String prepayId;
    /**
     * 时间戳 timeStamp
     */
    private String timeStamp;
    /**
     * sign 签名
     */
    private String sign;

    public String getNotifyUrl() {
        return notifyUrl == null ? "" : notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getBody() {
        return body;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public String getPrice() {
        return price;
    }

    public String getSubject() {
        return subject;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    /**
     * AliPay使用
     */
    public void setPrice(String price) {
        this.price = price;
    }

    /**
     * AliPay使用
     */
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getAliAppId() {
        return aliAppId == null ? "" : aliAppId;
    }

    public void setAliAppId(String aliAppId) {
        this.aliAppId = aliAppId;
    }

    public String getAppId() {
        return appId;
    }

    public String getPartnerId() {
        return partnerId;
    }

    public String getPackageValue() {
        return packageValue;
    }

    public String getNoncestr() {
        return noncestr;
    }

    public String getTimeStamp() {
        return timeStamp;
    }

    public String getSign() {
        return sign;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setNoncestr(String noncestr) {
        this.noncestr = noncestr;
    }

    public void setPackageValue(String packageValue) {
        this.packageValue = packageValue;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getPrepayId() {
        return prepayId;
    }

    public void setPrepayId(String prepayId) {
        this.prepayId = prepayId;
    }
}
