package com.zzh.lib.pay.uppay;

import android.text.TextUtils;

import com.zzh.lib.pay.model.HPayInfo;


/**
 * 构建支付参数，主要是银行返回的 TN，即 ：订单信息为交易流水号。
 * @Date: 2022/5/23 15:31
 * @Email: zzh_hz@126.com
 * @QQ: 1299234582
 * @Author: zzh
 * @Description: PayUrlGenerator.java
 */
public class PayUrlGenerator {

    private HPayInfo payInfo;


    public PayUrlGenerator(HPayInfo payInfo) {
        this.payInfo = payInfo;
    }

    public String genPayOrder() {

        validatePayInfo(payInfo);

        return payInfo.getOrderNo();
    }


    /**
     * 验证 支付参数的有效性
     *
     * @param payInfo
     * @return void
     * @autour BaoHong.Li
     * @date 2015-7-17 上午10:44:11
     * @update (date)
     */
    private void validatePayInfo(HPayInfo payInfo) {

        if (TextUtils.isEmpty(payInfo.getOrderNo())) {
            throw new IllegalArgumentException(" payInfo.orderNo is  null !");
        }
    }

}
