package com.zzh.lib.pay.wxpay;

import android.text.TextUtils;

import com.tencent.mm.opensdk.modelpay.PayReq;
import com.zzh.lib.pay.HPayAgent;
import com.zzh.lib.pay.L;
import com.zzh.lib.pay.model.HPayInfo;
import com.zzh.lib.pay.model.HPayKey;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Set;

/**
 * 构建 支付参数，sig等 支付金额 暂时没填
 *
 * @author BaoHong.Li
 * @version V1.0
 * @date 2015-7-16 下午4:27:02
 * @update (date)
 */
public class PayUrlGenerator {

    private static final String TAG = "PayUrlGenerator WX";

    private HPayInfo payInfo;

    private PayReq req;

    public PayUrlGenerator(HPayInfo payInfo) {
        this.payInfo = payInfo;
        this.req = new PayReq();
    }

    /**
     * 构建支付参数
     *
     * @return PayReq
     * @autour BaoHong.Li
     * @date 2015-7-20 下午3:51:44
     * @update (date)
     */
    public PayReq genPayReq() {

        validatePayInfo(this.payInfo);

        if (TextUtils.isEmpty(this.payInfo.getAppId())) {
            req.appId = HPayKey.WX_APP_ID;
        } else {
            req.appId = this.payInfo.getAppId();
        }

        if (TextUtils.isEmpty(this.payInfo.getPartnerId())) {
            req.partnerId = HPayKey.WX_MCH_ID;
        } else {
            req.partnerId = this.payInfo.getPartnerId();
        }
        req.prepayId = this.payInfo.getPrepayId();

        if (TextUtils.isEmpty(this.payInfo.getPackageValue())) {
            req.packageValue = "Sign=WXPay";
        } else {
            req.packageValue = this.payInfo.getPackageValue();
        }

        if (TextUtils.isEmpty(this.payInfo.getNoncestr())) {
            req.nonceStr = HPayAgent.getInstance().genNonceStr();
        } else {
            req.nonceStr = this.payInfo.getNoncestr();
        }

        if (TextUtils.isEmpty(this.payInfo.getTimeStamp())) {
            req.timeStamp = String.valueOf(genTimeStamp());
        } else {
            req.timeStamp = this.payInfo.getTimeStamp();
        }


        if (TextUtils.isEmpty(this.payInfo.getSign())) {
            LinkedHashMap<String, String> signParams = new LinkedHashMap<>();
            signParams.put("appid", req.appId);
            signParams.put("timestamp", req.timeStamp);
            signParams.put("noncestr", req.nonceStr);
            signParams.put("package", req.packageValue);
            signParams.put("partnerid", req.partnerId);
            signParams.put("prepayid", req.prepayId);
            req.sign = HPayAgent.getInstance().genAppSign(signParams);
        } else {
            req.sign = this.payInfo.getSign();
        }
        return this.req;
    }

    public String genAppSign(LinkedHashMap<String, String> params) {
        StringBuilder sb = new StringBuilder();

        Set<String> keySet = params.keySet();
        Object[] objects = keySet.toArray();
        Arrays.sort(objects);
        L.d(TAG, Arrays.toString(objects));
        for (Object key : objects) {
            sb.append(key);
            sb.append('=');
            sb.append(params.get(key));
            sb.append('&');
        }

        sb.append("key=");
        sb.append(HPayKey.WX_API_KEY);
        L.e(TAG, " genAppSign " + sb);
        String appSign = MD5.getMessageDigest(sb.toString().getBytes()).toUpperCase(Locale.getDefault());
        L.e(TAG, " genAppSign " + appSign);
        return appSign;
    }

    private long genTimeStamp() {
        return System.currentTimeMillis() / 1000;
    }

    /**
     * 验证 支付参数的有效性
     *
     * @param payInfo
     * @return void
     * @autour BaoHong.Li
     * @date 2015-7-17 上午10:44:11
     * @update (date)
     */
    private void validatePayInfo(HPayInfo payInfo) {
        if (TextUtils.isEmpty(payInfo.getOrderNo())) {
            throw new IllegalArgumentException(" payInfo.orderNo is  null !");
        }
    }

}
