package com.zzh.lib.pay.wxpay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;

import com.tencent.mm.opensdk.constants.ConstantsAPI;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.modelpay.PayReq;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.WXAPIFactory;
import com.zzh.lib.pay.L;
import com.zzh.lib.pay.OnPayListener;
import com.zzh.lib.pay.model.HPayInfo;
import com.zzh.lib.pay.model.HPayKey;


public class WechatPayHelper {

    private static final String TAG = WechatPayHelper.class.getName();

    private static OnPayListener mListener;

    private IWXAPI msgApi;

    public void setOnlineMode(boolean isOnlineMode) {

    }

    public void pay(final Activity activity, HPayInfo info, OnPayListener listener) {

        mListener = listener;
        if (null == msgApi) {
            registerWechatApi(activity);
        }

        PayUrlGenerator payUrlGenerator = new PayUrlGenerator(info);
        PayReq req = payUrlGenerator.genPayReq();

        if (null != mListener) {
            mListener.onStartPay();
        }

        msgApi.sendReq(req);
    }

    /**
     * 注册 微信sdk 到app
     *
     * @param activity
     * @return boolean
     */
    public boolean registerWechatApi(final Activity activity) {
        if (null == msgApi) {
            msgApi = WXAPIFactory.createWXAPI(activity, null);
        }
        return msgApi.registerApp(HPayKey.WX_APP_ID);
    }

    /**
     * 接收 支付回调
     *
     * @param resp
     * @return void
     */
    public static void handleOnResp(BaseResp resp) {
        L.d(TAG, " ====  handleOnResp ,resp:" + resp.toString() + " === ");
        if (resp.getType() == ConstantsAPI.COMMAND_PAY_BY_WX && resp.errCode == 0) {
            if (null != mListener) {
                mListener.onPaySuccess();
            }
            //支付失败
        } else {
            if (null != mListener) {
                mListener.onPayFail(String.valueOf(resp.errCode), resp.errStr);
            }
        }

    }

    /**
     * @param req
     * @return void
     */
    public static void handleOnReq(BaseReq req) {
        L.d(TAG, " ====== handleonReq =====");
    }

    public static void handleIntent(Intent intent, Context context) {

    }

}
