/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.pay;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Looper;
import android.util.Log;
import android.util.Xml;
import com.zzh.lib.pay.L;
import com.zzh.lib.pay.OnPayListener;
import com.zzh.lib.pay.alipay.AlipayHelper;
import com.zzh.lib.pay.model.HPayInfo;
import com.zzh.lib.pay.model.HPayKey;
import com.zzh.lib.pay.uppay.UpPayHelper;
import com.zzh.lib.pay.wxpay.MD5;
import com.zzh.lib.pay.wxpay.WechatPayHelper;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;

public class HPayAgent {
    private static final String TAG = "HPayAgent";
    private static boolean isInitAliPayKeys;
    private static boolean isInitWxPayKeys;
    private static boolean isInitUpPayKeys;
    public static final String ALIPAY_PARTNER_ID = "ALIPAY_PARTNER_ID";
    public static final String ALIPAY_SELLER_ID = "ALIPAY_SELLER_ID";
    public static final String ALIPAY_PRIVATE_KEY = "ALIPAY_PRIVATE_KEY";
    public static final String ALIPAY_PUBLIC_KEY = "ALIPAY_PUBLIC_KEY";
    public static final String ALIPAY_APP_ID = "ALIPAY_APP_ID";
    public static final String WXPAY_APP_ID = "WXPAY_APP_ID";
    public static final String WXPAY_MCH_ID = "WXPAY_MCH_ID";
    public static final String WXPAY_API_KEY = "WXPAY_API_KEY";
    public static final String UPPAY_PUBLICKEY_PM_MODULUS = "UPPAY_PUBLICKEY_PM_MODULUS";
    public static final String UPPAY_PUBLIC_EXPONENT = "UPPAY_PUBLIC_EXPONENT";
    public static final String UPPAY_PUBLIC_KEY_PRODUCT_MODULUS = "UPPAY_PUBLIC_KEY_PRODUCT_MODULUS";
    public PayType currentPayType;
    private boolean isInit;
    private static volatile HPayAgent instance;
    private AlipayHelper mAlipayHelper;
    private WechatPayHelper mWechatPayHelper;
    private UpPayHelper mUpPayHelper;
    ApplicationInfo appInfo = null;

    private HPayAgent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HPayAgent getInstance() {
        if (null != instance) return instance;
        Class<HPayAgent> clazz = HPayAgent.class;
        synchronized (HPayAgent.class) {
            if (null != instance) return instance;
            instance = new HPayAgent();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public AlipayHelper getAlipayHelper() {
        if (null == this.mAlipayHelper) {
            this.mAlipayHelper = new AlipayHelper();
        }
        return this.mAlipayHelper;
    }

    public WechatPayHelper getWechatPayHelper() {
        if (null == this.mWechatPayHelper) {
            this.mWechatPayHelper = new WechatPayHelper();
        }
        return this.mWechatPayHelper;
    }

    public UpPayHelper getUpPayHelper() {
        if (null == this.mUpPayHelper) {
            this.mUpPayHelper = new UpPayHelper();
        }
        return this.mUpPayHelper;
    }

    public PayType getCurrentPayType() {
        return this.currentPayType;
    }

    public void setDebug(boolean debug) {
        L.isDebug = debug;
    }

    public void setOnlineMode(boolean isOnlineMode) {
        this.getAlipayHelper().setOnlineMode(isOnlineMode);
        this.getUpPayHelper().setOnlineMode(isOnlineMode);
        this.getWechatPayHelper().setOnlineMode(isOnlineMode);
    }

    public synchronized boolean initPay(Activity activity) {
        if (this.isInit) {
            return true;
        }
        boolean success = true;
        success &= this.initKeys((Context)activity);
        this.isInit = true;
        return success &= this.getWechatPayHelper().registerWechatApi(activity);
    }

    public boolean initKeys(Context activity) {
        if (!isInitAliPayKeys) {
            HPayKey.ALI_PARTNER_ID = this.getMetaData(activity, ALIPAY_PARTNER_ID);
            HPayKey.ALI_APP_ID = this.getMetaData(activity, ALIPAY_APP_ID);
            HPayKey.ALI_SELLER_ID = this.getMetaData(activity, ALIPAY_SELLER_ID);
            HPayKey.ALI_PRIVATE_KEY = this.getMetaData(activity, ALIPAY_PRIVATE_KEY);
            HPayKey.ALI_PAY_PUBLIC_KEY = this.getMetaData(activity, ALIPAY_PUBLIC_KEY);
            isInitAliPayKeys = true;
        }
        if (!isInitWxPayKeys) {
            HPayKey.WX_APP_ID = this.getMetaData(activity, WXPAY_APP_ID);
            HPayKey.WX_MCH_ID = this.getMetaData(activity, WXPAY_MCH_ID);
            HPayKey.WX_API_KEY = this.getMetaData(activity, WXPAY_API_KEY);
            isInitWxPayKeys = true;
        }
        if (!isInitUpPayKeys) {
            HPayKey.UP_PUBLIC_EXPONENT = this.getMetaData(activity, UPPAY_PUBLIC_EXPONENT);
            HPayKey.UP_PUBLIC_KEY_PM_MODULES = this.getMetaData(activity, UPPAY_PUBLICKEY_PM_MODULUS);
            HPayKey.UP_PUBLIC_KEY_PRODUCT_MODULES = this.getMetaData(activity, UPPAY_PUBLIC_KEY_PRODUCT_MODULUS);
            isInitUpPayKeys = true;
        }
        return true;
    }

    public String getMetaData(Context ctx, String key) {
        this.appInfo = null;
        String value = "";
        try {
            if (this.appInfo == null) {
                this.appInfo = ctx.getPackageManager().getApplicationInfo(ctx.getPackageName(), 128);
            }
            value = String.valueOf(this.appInfo.metaData.get(key));
            L.d(TAG, "meta-data :key: " + key);
            L.d(TAG, "  meta-data :value: " + value);
        }
        catch (PackageManager.NameNotFoundException e) {
            L.w(TAG, e.getMessage());
        }
        return value;
    }

    public static boolean initAliPayKeys(String partnerId, String sellerId, String privateKey, String publicKey) {
        HPayKey.ALI_PARTNER_ID = partnerId;
        HPayKey.ALI_SELLER_ID = sellerId;
        HPayKey.ALI_PRIVATE_KEY = privateKey;
        HPayKey.ALI_PAY_PUBLIC_KEY = publicKey;
        isInitAliPayKeys = true;
        return true;
    }

    public boolean initWxPayKeys(String appId, String mchId, String appKey) {
        HPayKey.WX_APP_ID = appId;
        HPayKey.WX_MCH_ID = mchId;
        HPayKey.WX_API_KEY = appKey;
        isInitWxPayKeys = true;
        return true;
    }

    public boolean initUpPayKeys(String PublicKeyPMModulus, String publicExponent, String PublicKeyProductModulus) {
        HPayKey.UP_PUBLIC_KEY_PM_MODULES = PublicKeyPMModulus;
        HPayKey.UP_PUBLIC_KEY_PRODUCT_MODULES = PublicKeyProductModulus;
        HPayKey.UP_PUBLIC_EXPONENT = publicExponent;
        isInitUpPayKeys = true;
        return true;
    }

    public void payOfAliPay(Activity activity, HPayInfo payInfo, OnPayListener listener) {
        this.onPay(PayType.ALIPAY, activity, payInfo, listener);
    }

    public void payOfWechatPay(Activity activity, HPayInfo payInfo, OnPayListener listener) {
        this.onPay(PayType.WECHAT, activity, payInfo, listener);
    }

    public void payOfUpPay(Activity activity, HPayInfo payInfo, OnPayListener listener) {
        this.onPay(PayType.UP, activity, payInfo, listener);
    }

    public void onPay(PayType payType, Activity activity, HPayInfo payInfo, OnPayListener listener) {
        this.currentPayType = payType;
        if (!this.isInit) {
            this.initPay(activity);
        }
        if (null == payInfo) {
            throw new IllegalArgumentException(" payinfo  is null!");
        }
        if (null == activity) {
            throw new IllegalArgumentException(" Activity  is null!");
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalArgumentException(Thread.currentThread().getName() + "'. onPay methods must be called on the UI thread. ");
        }
        switch (payType) {
            case ALIPAY: {
                this.getAlipayHelper().pay(activity, payInfo, listener);
                break;
            }
            case WECHAT: {
                this.getWechatPayHelper().pay(activity, payInfo, listener);
                break;
            }
            case UP: {
                this.getUpPayHelper().pay(activity, payInfo, listener);
                break;
            }
            default: {
                throw new IllegalArgumentException(" payType is ALIPAY or WXPAY ");
            }
        }
    }

    public String genNonceStr() {
        Random random = new Random();
        return MD5.getMessageDigest(String.valueOf(random.nextInt(10000)).getBytes());
    }

    public String genAppSign(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        Set<String> keySet = params.keySet();
        Object[] objects = keySet.toArray();
        Arrays.sort(objects);
        L.d(TAG, Arrays.toString(objects));
        for (Object key : objects) {
            sb.append(key);
            sb.append('=');
            sb.append(params.get(key));
            sb.append('&');
        }
        sb.append("key=");
        sb.append(HPayKey.WX_API_KEY);
        L.e(TAG, " genAppSign " + sb);
        String appSign = MD5.getMessageDigest(sb.toString().getBytes()).toUpperCase(Locale.getDefault());
        L.e(TAG, " genAppSign " + appSign);
        return appSign;
    }

    public final String xmlWeChatPay(Map<String, String> map) {
        StringBuilder builder = new StringBuilder("<xml>");
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            builder.append("<").append(key).append(">").append(map.get(key)).append("</").append(key).append(">");
        }
        builder.append("</xml>");
        return builder.toString();
    }

    public final Map<String, String> decodeXml(String content) {
        try {
            HashMap<String, String> xml = new HashMap<String, String>();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((Reader)new StringReader(content));
            int event = parser.getEventType();
            while (event != 1) {
                String nodeName = parser.getName();
                switch (event) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        if ("xml".equals(nodeName)) break;
                        xml.put(nodeName, parser.nextText());
                        break;
                    }
                }
                event = parser.next();
            }
            return xml;
        }
        catch (Exception e) {
            Log.e((String)"orion", (String)e.toString());
            return null;
        }
    }

    public static enum PayType {
        ALIPAY,
        WECHAT,
        UP;

    }
}

