/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.pay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.IWXAPIEventHandler;
import com.tencent.mm.opensdk.openapi.WXAPIFactory;
import com.unionpay.UPPayAssistEx;
import com.zzh.lib.pay.HPayAgent;
import com.zzh.lib.pay.L;
import com.zzh.lib.pay.model.HPayKey;
import com.zzh.lib.pay.uppay.UpPayHelper;
import com.zzh.lib.pay.wxpay.WechatPayHelper;

public class PaymentActivity
extends Activity
implements IWXAPIEventHandler {
    private static final String TAG = PaymentActivity.class.getName();
    private IWXAPI api;
    private HPayAgent payAgent = HPayAgent.getInstance();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.handlePayInit();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
        if (this.payAgent.getCurrentPayType() == HPayAgent.PayType.WECHAT) {
            this.api.handleIntent(intent, (IWXAPIEventHandler)this);
            WechatPayHelper.handleIntent(intent, (Context)this);
        } else if (this.payAgent.getCurrentPayType() == HPayAgent.PayType.UP) {
            UpPayHelper.handleIntent(intent, (Context)this);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.payAgent.getCurrentPayType() == HPayAgent.PayType.UP) {
            UpPayHelper.onActivityResult(requestCode, resultCode, data);
            this.finish();
        }
    }

    public void onReq(BaseReq req) {
        L.d(TAG, " === wxPay onReq " + req.toString() + " === ");
        WechatPayHelper.handleOnReq(req);
    }

    public void onResp(BaseResp resp) {
        L.d(TAG, " ==== wxPay onResp ===" + resp.errStr + ";code=" + String.valueOf(resp.errCode));
        WechatPayHelper.handleOnResp(resp);
        this.finish();
    }

    private void handlePayInit() {
        switch (this.payAgent.getCurrentPayType()) {
            case WECHAT: {
                this.api = WXAPIFactory.createWXAPI((Context)this, (String)HPayKey.WX_APP_ID);
                this.api.handleIntent(this.getIntent(), (IWXAPIEventHandler)this);
                break;
            }
            case UP: {
                String orderInfo = this.getIntent().getStringExtra("orderInfo");
                if (TextUtils.isEmpty((CharSequence)orderInfo)) {
                    L.e(TAG, "orderInfo is null");
                }
                UPPayAssistEx.startPay((Context)this, null, null, (String)orderInfo, (String)UpPayHelper.payMode);
                break;
            }
        }
    }
}

