/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.pay.alipay;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.alipay.sdk.app.PayTask;
import com.zzh.lib.pay.L;
import com.zzh.lib.pay.OnPayListener;
import com.zzh.lib.pay.alipay.PayUrlGenerator;
import com.zzh.lib.pay.alipay.Result;
import com.zzh.lib.pay.model.HPayInfo;
import java.util.Map;

public class AlipayHelper {
    protected static final int RQF_PAY = 0;
    private String payInfo;
    private OnPayListener onPayResultListener;
    private Handler handler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    if (AlipayHelper.this.onPayResultListener == null) break;
                    Result result = new Result((Map)msg.obj);
                    if (TextUtils.equals((CharSequence)result.resultCode, (CharSequence)"9000")) {
                        AlipayHelper.this.onPayResultListener.onPaySuccess();
                        break;
                    }
                    if (TextUtils.isEmpty((CharSequence)result.resultMsg)) {
                        AlipayHelper.this.onPayResultListener.onPayFail(result.resultCode, "\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u6211\u7684\u8ba2\u5355\u518d\u8bd5");
                        return;
                    }
                    if (TextUtils.equals((CharSequence)result.resultCode, (CharSequence)"8000")) {
                        AlipayHelper.this.onPayResultListener.onPayFail(result.resultCode, result.resultMsg);
                        break;
                    }
                    AlipayHelper.this.onPayResultListener.onPayFail(result.resultCode, result.resultMsg);
                    break;
                }
            }
        }
    };

    public void setOnlineMode(boolean isOnlineMode) {
    }

    public void pay(final Activity activity, HPayInfo info, OnPayListener l) {
        this.onPayResultListener = l;
        PayUrlGenerator generator = new PayUrlGenerator(info);
        this.payInfo = generator.generatePayUrl();
        new Thread(new Runnable(){

            @Override
            public void run() {
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (null != AlipayHelper.this.onPayResultListener) {
                            AlipayHelper.this.onPayResultListener.onStartPay();
                        }
                    }
                });
                PayTask aliPay = new PayTask(activity);
                Map result = aliPay.payV2(AlipayHelper.this.payInfo, true);
                L.i(AlipayHelper.class.getName(), "pay result :" + result);
                Message msg = new Message();
                msg.what = 0;
                msg.obj = result;
                AlipayHelper.this.handler.sendMessage(msg);
            }
        }).start();
    }

    public static interface OnPayResultListener {
        public void onPayResult(String var1, String var2);
    }
}

