/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.pay.alipay;

import android.text.TextUtils;
import com.zzh.lib.pay.L;
import com.zzh.lib.pay.alipay.Base64;
import com.zzh.lib.pay.model.HPayInfo;
import com.zzh.lib.pay.model.HPayKey;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PayUrlGenerator {
    private static final String TAG = "PayUrlGenerator";
    private HPayInfo payInfo;

    public PayUrlGenerator(HPayInfo payInfo) {
        this.payInfo = payInfo;
    }

    public String generatePayUrl() {
        if (this.payInfo == null) {
            L.e(TAG, " +++++ orderInfo is null");
            return "";
        }
        this.validatePayInfo(this.payInfo);
        Map<String, String> paramMap = this.buildOrderParamMap();
        String orderInfo = this.buildOrderParam(paramMap);
        String sign = this.genOrderInfo(paramMap);
        L.e("orderInfo: ", orderInfo);
        StringBuilder sb = new StringBuilder(orderInfo);
        sb.append("&sign=");
        sb.append(sign);
        String payUrl = sb.toString();
        L.i(TAG, "pay info:" + payUrl);
        return payUrl;
    }

    private String genOrderInfo(Map<String, String> map) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        StringBuilder authInfo = new StringBuilder();
        for (int i = 0; i < keys.size() - 1; ++i) {
            String key = (String)keys.get(i);
            String value = map.get(key);
            authInfo.append(this.buildKeyValue(key, value, false));
            authInfo.append("&");
        }
        String tailKey = (String)keys.get(keys.size() - 1);
        String tailValue = map.get(tailKey);
        authInfo.append(this.buildKeyValue(tailKey, tailValue, false));
        String oriSign = this.signUrl(authInfo.toString());
        String encodedSign = "";
        try {
            encodedSign = URLEncoder.encode(oriSign, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encodedSign;
    }

    public String buildOrderParam(Map<String, String> map) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keys.size() - 1; ++i) {
            String key = (String)keys.get(i);
            String value = map.get(key);
            sb.append(this.buildKeyValue(key, value, true));
            sb.append("&");
        }
        String tailKey = (String)keys.get(keys.size() - 1);
        String tailValue = map.get(tailKey);
        sb.append(this.buildKeyValue(tailKey, tailValue, true));
        return sb.toString();
    }

    private String buildKeyValue(String key, String value, boolean isEncode) {
        StringBuilder sb = new StringBuilder();
        sb.append(key);
        sb.append("=");
        if (isEncode) {
            try {
                sb.append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                sb.append(value);
            }
        } else {
            sb.append(value);
        }
        return sb.toString();
    }

    public Map<String, String> buildOrderParamMap() {
        HashMap<String, String> keyValues = new HashMap<String, String>();
        String appId = TextUtils.isEmpty((CharSequence)this.payInfo.getAliAppId()) ? HPayKey.ALI_APP_ID : this.payInfo.getAliAppId();
        keyValues.put("app_id", appId);
        keyValues.put("biz_content", "{\"timeout_express\":\"" + this.payInfo.getAliTimeoutExpress() + "\",\"product_code\":\"QUICK_MSECURITY_PAY\",\"total_amount\":\"" + this.payInfo.getPrice() + "\",\"subject\":\"" + this.payInfo.getSubject() + "\",\"body\":\"" + this.payInfo.getBody() + "\",\"out_trade_no\":\"" + this.payInfo.getOrderNo() + "\"}");
        keyValues.put("charset", "utf-8");
        keyValues.put("method", "alipay.trade.app.pay");
        keyValues.put("sign_type", "RSA2");
        keyValues.put("notify_url", this.payInfo.getNotifyUrl());
        String timestamp = TextUtils.isEmpty((CharSequence)this.payInfo.getTimeStamp()) ? this.getDateTime() : this.payInfo.getTimeStamp();
        keyValues.put("timestamp", timestamp);
        keyValues.put("version", "1.0");
        return keyValues;
    }

    private String getDateTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(System.currentTimeMillis());
    }

    private String signUrl(String urlToSign) {
        try {
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.decode(HPayKey.ALI_PRIVATE_KEY));
            KeyFactory keyf = KeyFactory.getInstance("RSA");
            PrivateKey priKey = keyf.generatePrivate(priPKCS8);
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initSign(priKey);
            signature.update(urlToSign.getBytes("UTF-8"));
            byte[] signed = signature.sign();
            return Base64.encode(signed);
        }
        catch (Exception e) {
            L.e(e.getMessage(), e);
            return null;
        }
    }

    private void validatePayInfo(HPayInfo payInfo) {
        if (TextUtils.isEmpty((CharSequence)payInfo.getOrderNo())) {
            throw new IllegalArgumentException(" payInfo.orderNo is  null !");
        }
        if (TextUtils.isEmpty((CharSequence)payInfo.getAliAppId()) && TextUtils.isEmpty((CharSequence)HPayKey.ALI_APP_ID)) {
            throw new IllegalArgumentException(" payInfo.aliAppId is  null !");
        }
        if (TextUtils.isEmpty((CharSequence)payInfo.getBody())) {
            throw new IllegalArgumentException(" payInfo.body is  null !");
        }
        if (TextUtils.isEmpty((CharSequence)payInfo.getPrice())) {
            throw new IllegalArgumentException(" payInfo.price is  null !");
        }
        if (TextUtils.isEmpty((CharSequence)payInfo.getSubject())) {
            throw new IllegalArgumentException(" payInfo.subject is  null !");
        }
    }
}

