/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.pay.alipay;

import android.text.TextUtils;
import com.zzh.lib.pay.L;
import com.zzh.lib.pay.alipay.Rsa;
import com.zzh.lib.pay.model.HPayKey;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class Result {
    private static final Map<String, String> sResultStatus = new HashMap<String, String>();
    private String mResult;
    String resultCode = null;
    String resultMsg = null;
    String memo = null;
    String result = null;
    boolean isSignOk = false;

    public Result(String result) {
        this.mResult = result;
    }

    public Result(Map<String, String> rawResult) {
        if (rawResult == null) {
            return;
        }
        for (String key : rawResult.keySet()) {
            if (TextUtils.equals((CharSequence)key, (CharSequence)"resultStatus")) {
                this.resultCode = rawResult.get(key);
                this.resultMsg = sResultStatus.get(this.resultCode);
                continue;
            }
            if (TextUtils.equals((CharSequence)key, (CharSequence)"result")) {
                this.result = rawResult.get(key);
                continue;
            }
            if (!TextUtils.equals((CharSequence)key, (CharSequence)"memo")) continue;
            this.memo = rawResult.get(key);
        }
    }

    public JSONObject string2JSON(String src, String split) {
        JSONObject json = new JSONObject();
        try {
            String[] arr = src.split(split);
            for (int i = 0; i < arr.length; ++i) {
                String[] arrKey = arr[i].split("=");
                json.put(arrKey[0], (Object)arr[i].substring(arrKey[0].length() + 1));
            }
        }
        catch (Exception e) {
            L.e(e.getMessage(), e);
        }
        return json;
    }

    private boolean checkSign(String result) {
        if (TextUtils.isEmpty((CharSequence)result)) {
            return false;
        }
        boolean retVal = false;
        try {
            JSONObject json = this.string2JSON(result, "&");
            int pos = result.indexOf("&sign=");
            String signContent = result.substring(0, pos);
            String signType = json.getString("sign_type");
            signType = signType.replace("\"", "");
            String sign = json.getString("sign");
            sign = sign.replace("\"", "");
            if (signType.equalsIgnoreCase("RSA")) {
                retVal = Rsa.doCheck(signContent, sign, HPayKey.ALI_PAY_PUBLIC_KEY);
            }
        }
        catch (Exception e) {
            L.e("Result", "Exception =" + e.getMessage(), e);
        }
        L.i("Result", "checkSign =" + retVal);
        return retVal;
    }

    private String getContent(String src, String startTag, String endTag) {
        String content = src;
        int start = src.indexOf(startTag);
        start += startTag.length();
        try {
            if (endTag != null) {
                int end = src.indexOf(endTag);
                content = src.substring(start, end);
            } else {
                content = src.substring(start);
            }
        }
        catch (Exception e) {
            L.e(e.getMessage(), e);
        }
        return content;
    }

    static {
        sResultStatus.put("9000", "\u64cd\u4f5c\u6210\u529f");
        sResultStatus.put("4000", "\u7cfb\u7edf\u5f02\u5e38");
        sResultStatus.put("4001", "\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e");
        sResultStatus.put("4003", "\u8be5\u7528\u6237\u7ed1\u5b9a\u7684\u652f\u4ed8\u5b9d\u8d26\u6237\u88ab\u51bb\u7ed3\u6216\u4e0d\u5141\u8bb8\u652f\u4ed8");
        sResultStatus.put("4004", "\u8be5\u7528\u6237\u5df2\u89e3\u9664\u7ed1\u5b9a");
        sResultStatus.put("4005", "\u7ed1\u5b9a\u5931\u8d25\u6216\u6ca1\u6709\u7ed1\u5b9a");
        sResultStatus.put("4006", "\u8ba2\u5355\u652f\u4ed8\u5931\u8d25");
        sResultStatus.put("4010", "\u91cd\u65b0\u7ed1\u5b9a\u8d26\u6237");
        sResultStatus.put("6000", "\u652f\u4ed8\u670d\u52a1\u6b63\u5728\u8fdb\u884c\u5347\u7ea7\u64cd\u4f5c");
        sResultStatus.put("6001", "\u7528\u6237\u4e2d\u9014\u53d6\u6d88\u652f\u4ed8\u64cd\u4f5c");
        sResultStatus.put("7001", "\u7f51\u9875\u652f\u4ed8\u5931\u8d25");
    }
}

