/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.pay.uppay;

import android.annotation.SuppressLint;
import android.util.Base64;
import com.zzh.lib.pay.model.HPayKey;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class UPPayRSAUtil {
    public static final String RSA = "RSA";
    public static final String RSA_PADDING_MODE = "RSA";
    public static final String ALGORITHM_RSA_SIGN = "SHA1withRSA";
    private static final String RSA_NOPADDING = "RSA/ECB/NoPadding";
    public static final int RSAKEYLEN = 2048;
    public static final String KEY_LABEL = "key_label";
    public static final String DATA = "data";
    public static final String TEXT = "text";
    private static PrivateKey privateKey;
    private static PublicKey publicKey;
    public static PublicKey clientPublicKey;

    public static PublicKey getPublicKey() {
        return publicKey;
    }

    public static PrivateKey getPrivateKey() {
        return privateKey;
    }

    @SuppressLint(value={"TrulyRandom"})
    public static byte[] encrypt(byte[] data, PublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] decrypt(byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, UPPayRSAUtil.getPrivateKey());
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] decrypt(PrivateKey priKey, byte[] data, String padding, String provider) {
        try {
            Cipher cipher = Cipher.getInstance(padding, provider);
            cipher.init(2, priKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PublicKey generateRSAPublicKey(byte[] key) {
        try {
            X509EncodedKeySpec bobPubKeySpec = new X509EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey pubKey = keyFactory.generatePublic(bobPubKeySpec);
            return pubKey;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PrivateKey generateRSAPrivateKey(byte[] key) {
        try {
            PKCS8EncodedKeySpec pkcs8keyspec = new PKCS8EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey priKey = keyFactory.generatePrivate(pkcs8keyspec);
            return priKey;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PrivateKey generateRSAPrivateKey(String modulus, String privateExponent) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPrivateKeySpec pubKeySpec = new RSAPrivateKeySpec(new BigInteger(modulus), new BigInteger(privateExponent));
            return keyFactory.generatePrivate(pubKeySpec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encryptDataBytes(PublicKey publicKey, byte[] data) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
            cipher.init(1, publicKey);
            int blockSize = cipher.getBlockSize();
            int outputSize = cipher.getOutputSize(data.length);
            int leavedSize = data.length % blockSize;
            int blocksSize = leavedSize != 0 ? data.length / blockSize + 1 : data.length / blockSize;
            byte[] raw = new byte[outputSize * blocksSize];
            int i = 0;
            while (data.length - i * blockSize > 0) {
                if (data.length - i * blockSize > blockSize) {
                    cipher.doFinal(data, i * blockSize, blockSize, raw, i * outputSize);
                } else {
                    cipher.doFinal(data, i * blockSize, data.length - i * blockSize, raw, i * outputSize);
                }
                ++i;
            }
            return raw;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public static PrivateKey getPrivateKey(String priKeyData) throws Exception {
        BigInteger modulus = new BigInteger(priKeyData.substring(8, 520), 16);
        BigInteger publicExponent = new BigInteger(priKeyData.substring(520, 1032), 16);
        BigInteger privateExponent = new BigInteger(priKeyData.substring(1032, 1544), 16);
        BigInteger primeP = new BigInteger(priKeyData.substring(1544, 1800), 16);
        BigInteger primeQ = new BigInteger(priKeyData.substring(1800, 2056), 16);
        BigInteger primeExponentP = new BigInteger(priKeyData.substring(2056, 2312), 16);
        BigInteger primeExponentQ = new BigInteger(priKeyData.substring(2312, 2568), 16);
        BigInteger crtCoefficient = new BigInteger(priKeyData.substring(2568, 2824), 16);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        RSAPrivateCrtKeySpec rsaPrivateKeySpec = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
        return keyFactory.generatePrivate(rsaPrivateKeySpec);
    }

    public static PublicKey getPublicKey(String modulus, String publicExponent) throws NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger bigIntModulus = new BigInteger(modulus, 16);
        BigInteger bigIntPublicExponent = new BigInteger(publicExponent, 16);
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(bigIntModulus, bigIntPublicExponent);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    public static PublicKey generateRSAPublicKey(String modulus, String publicExponent) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(new BigInteger(modulus), new BigInteger(publicExponent));
            return keyFactory.generatePublic(pubKeySpec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PublicKey getPublicKeyPM() {
        String modulus = HPayKey.UP_PUBLIC_KEY_PM_MODULES;
        String publicExponent = HPayKey.UP_PUBLIC_EXPONENT;
        PublicKey publicKey = UPPayRSAUtil.generateRSAPublicKey(modulus, publicExponent);
        return publicKey;
    }

    public static PublicKey getPublicKeyProduct() {
        String modulus = HPayKey.UP_PUBLIC_KEY_PRODUCT_MODULES;
        String publicExponent = HPayKey.UP_PUBLIC_EXPONENT;
        PublicKey publicKey = UPPayRSAUtil.generateRSAPublicKey(modulus, publicExponent);
        return publicKey;
    }

    public static boolean verifyPM(byte[] message, byte[] signature) throws Exception {
        Signature sig = Signature.getInstance(ALGORITHM_RSA_SIGN);
        sig.initVerify(UPPayRSAUtil.getPublicKeyPM());
        sig.update(message);
        return sig.verify(signature);
    }

    public static boolean verifyProduct(byte[] message, byte[] signature) throws Exception {
        Signature sig = Signature.getInstance(ALGORITHM_RSA_SIGN);
        sig.initVerify(UPPayRSAUtil.getPublicKeyProduct());
        sig.update(message);
        return sig.verify(signature);
    }

    public static String sha1(byte[] raw) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.reset();
            messageDigest.update(raw);
            byte[] bytes = messageDigest.digest();
            return UPPayRSAUtil.bytesToHex(bytes);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static boolean verify(String msg, String sign64, String mode) {
        boolean ret = false;
        try {
            if ("01".equals(mode)) {
                ret = UPPayRSAUtil.verifyPM(UPPayRSAUtil.sha1(msg.getBytes()).getBytes(), Base64.decode((String)sign64, (int)2));
            } else if ("00".equals(mode)) {
                ret = UPPayRSAUtil.verifyProduct(UPPayRSAUtil.sha1(msg.getBytes()).getBytes(), Base64.decode((String)sign64, (int)2));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static byte[] hexToBytes(String hex) {
        return UPPayRSAUtil.hexToBytes(hex.toCharArray());
    }

    public static byte[] hexToBytes(char[] hex) {
        int length = hex.length / 2;
        byte[] raw = new byte[length];
        for (int i = 0; i < length; ++i) {
            int low;
            int high = Character.digit(hex[i * 2], 16);
            int value = high << 4 | (low = Character.digit(hex[i * 2 + 1], 16));
            if (value > 127) {
                value -= 256;
            }
            raw[i] = (byte)value;
        }
        return raw;
    }

    public static String bytesToHex(byte[] bytes) {
        String hexArray = "0123456789abcdef";
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            int bi = b & 0xFF;
            sb.append(hexArray.charAt(bi >> 4));
            sb.append(hexArray.charAt(bi & 0xF));
        }
        return sb.toString();
    }

    public static String publicDecrypt(PublicKey key, byte[] enc) {
        Cipher cipher = null;
        String decText = "";
        if (null == enc) {
            return decText;
        }
        try {
            cipher = Cipher.getInstance(RSA_NOPADDING);
            cipher.init(2, key);
            byte[] enBytes = cipher.doFinal(enc);
            decText = UPPayRSAUtil.bytesToHex(enBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return decText;
    }
}

