/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.pay.uppay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.zzh.lib.pay.L;
import com.zzh.lib.pay.OnPayListener;
import com.zzh.lib.pay.PaymentActivity;
import com.zzh.lib.pay.model.HPayInfo;
import com.zzh.lib.pay.uppay.PayUrlGenerator;
import org.json.JSONException;
import org.json.JSONObject;

public class UpPayHelper {
    private static final String TAG = UpPayHelper.class.getName();
    private static OnPayListener mListener;
    public static String payMode;

    public void setOnlineMode(boolean isOnlineMode) {
        payMode = isOnlineMode ? "00" : "01";
    }

    public void pay(Activity activity, HPayInfo info, OnPayListener listener) {
        this.pay(activity, info, listener, payMode);
    }

    public void pay(Activity activity, HPayInfo info, OnPayListener listener, String mode) {
        mListener = listener;
        PayUrlGenerator payUrlGenerator = new PayUrlGenerator(info);
        String orderInfo = payUrlGenerator.genPayOrder();
        if (null != mListener) {
            mListener.onStartPay();
        }
        Intent intent = new Intent((Context)activity, PaymentActivity.class);
        intent.putExtra("orderInfo", orderInfo);
        activity.startActivity(intent);
    }

    public static void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (data == null) {
            return;
        }
        String msg = "";
        String str = data.getExtras().getString("pay_result");
        if (!TextUtils.isEmpty((CharSequence)str)) {
            L.d(TAG, str);
        }
        if (null != str && str.equalsIgnoreCase("success")) {
            if (data.hasExtra("result_data")) {
                String result = data.getExtras().getString("result_data");
                if (!TextUtils.isEmpty((CharSequence)result)) {
                    L.d(TAG, result);
                }
                try {
                    JSONObject resultJson = new JSONObject(result);
                    String sign = resultJson.getString("sign");
                    String dataOrg = resultJson.getString("data");
                    boolean ret = UpPayHelper.verify(dataOrg, sign, payMode);
                    if (ret) {
                        msg = "\u652f\u4ed8\u6210\u529f\uff01";
                        if (null != mListener) {
                            mListener.onPaySuccess();
                        }
                    } else {
                        msg = "\u652f\u4ed8\u5931\u8d25\uff01";
                        if (null != mListener) {
                            mListener.onPayFail(String.valueOf(0), msg);
                        }
                    }
                }
                catch (JSONException e) {
                    L.w(TAG, e);
                }
            } else {
                msg = "\u652f\u4ed8\u6210\u529f\uff01";
                if (null != mListener) {
                    mListener.onPaySuccess();
                }
            }
        } else if (str.equalsIgnoreCase("fail")) {
            msg = "\u652f\u4ed8\u5931\u8d25\uff01";
            if (null != mListener) {
                mListener.onPayFail(String.valueOf(0), msg);
            }
        } else if (str.equalsIgnoreCase("cancel")) {
            msg = "\u7528\u6237\u53d6\u6d88\u4e86\u652f\u4ed8";
            if (null != mListener) {
                mListener.onPayFail(String.valueOf(0), msg);
            }
        }
    }

    public static void handleIntent(Intent intent, Context context) {
    }

    private static boolean verify(String msg, String sign64, String mode) {
        return true;
    }

    static {
        payMode = "00";
    }
}

