/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.pay.wxpay;

import android.text.TextUtils;
import com.tencent.mm.opensdk.modelpay.PayReq;
import com.zzh.lib.pay.HPayAgent;
import com.zzh.lib.pay.L;
import com.zzh.lib.pay.model.HPayInfo;
import com.zzh.lib.pay.model.HPayKey;
import com.zzh.lib.pay.wxpay.MD5;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Set;

public class PayUrlGenerator {
    private static final String TAG = "PayUrlGenerator WX";
    private HPayInfo payInfo;
    private PayReq req;

    public PayUrlGenerator(HPayInfo payInfo) {
        this.payInfo = payInfo;
        this.req = new PayReq();
    }

    public PayReq genPayReq() {
        this.validatePayInfo(this.payInfo);
        this.req.appId = TextUtils.isEmpty((CharSequence)this.payInfo.getAppId()) ? HPayKey.WX_APP_ID : this.payInfo.getAppId();
        this.req.partnerId = TextUtils.isEmpty((CharSequence)this.payInfo.getPartnerId()) ? HPayKey.WX_MCH_ID : this.payInfo.getPartnerId();
        this.req.prepayId = this.payInfo.getPrepayId();
        this.req.packageValue = TextUtils.isEmpty((CharSequence)this.payInfo.getPackageValue()) ? "Sign=WXPay" : this.payInfo.getPackageValue();
        this.req.nonceStr = TextUtils.isEmpty((CharSequence)this.payInfo.getNoncestr()) ? HPayAgent.getInstance().genNonceStr() : this.payInfo.getNoncestr();
        this.req.timeStamp = TextUtils.isEmpty((CharSequence)this.payInfo.getTimeStamp()) ? String.valueOf(this.genTimeStamp()) : this.payInfo.getTimeStamp();
        if (TextUtils.isEmpty((CharSequence)this.payInfo.getSign())) {
            LinkedHashMap<String, String> signParams = new LinkedHashMap<String, String>();
            signParams.put("appid", this.req.appId);
            signParams.put("timestamp", this.req.timeStamp);
            signParams.put("noncestr", this.req.nonceStr);
            signParams.put("package", this.req.packageValue);
            signParams.put("partnerid", this.req.partnerId);
            signParams.put("prepayid", this.req.prepayId);
            this.req.sign = HPayAgent.getInstance().genAppSign(signParams);
        } else {
            this.req.sign = this.payInfo.getSign();
        }
        return this.req;
    }

    public String genAppSign(LinkedHashMap<String, String> params) {
        StringBuilder sb = new StringBuilder();
        Set<String> keySet = params.keySet();
        Object[] objects = keySet.toArray();
        Arrays.sort(objects);
        L.d(TAG, Arrays.toString(objects));
        for (Object key : objects) {
            sb.append(key);
            sb.append('=');
            sb.append(params.get(key));
            sb.append('&');
        }
        sb.append("key=");
        sb.append(HPayKey.WX_API_KEY);
        L.e(TAG, " genAppSign " + sb);
        String appSign = MD5.getMessageDigest(sb.toString().getBytes()).toUpperCase(Locale.getDefault());
        L.e(TAG, " genAppSign " + appSign);
        return appSign;
    }

    private long genTimeStamp() {
        return System.currentTimeMillis() / 1000L;
    }

    private void validatePayInfo(HPayInfo payInfo) {
        if (TextUtils.isEmpty((CharSequence)payInfo.getOrderNo())) {
            throw new IllegalArgumentException(" payInfo.orderNo is  null !");
        }
    }
}

