/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.pay.wxpay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.modelpay.PayReq;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.WXAPIFactory;
import com.zzh.lib.pay.L;
import com.zzh.lib.pay.OnPayListener;
import com.zzh.lib.pay.model.HPayInfo;
import com.zzh.lib.pay.model.HPayKey;
import com.zzh.lib.pay.wxpay.PayUrlGenerator;

public class WechatPayHelper {
    private static final String TAG = WechatPayHelper.class.getName();
    private static OnPayListener mListener;
    private IWXAPI msgApi;

    public void setOnlineMode(boolean isOnlineMode) {
    }

    public void pay(Activity activity, HPayInfo info, OnPayListener listener) {
        mListener = listener;
        if (null == this.msgApi) {
            this.registerWechatApi(activity);
        }
        PayUrlGenerator payUrlGenerator = new PayUrlGenerator(info);
        PayReq req = payUrlGenerator.genPayReq();
        if (null != mListener) {
            mListener.onStartPay();
        }
        this.msgApi.sendReq((BaseReq)req);
    }

    public boolean registerWechatApi(Activity activity) {
        if (null == this.msgApi) {
            this.msgApi = WXAPIFactory.createWXAPI((Context)activity, null);
        }
        return this.msgApi.registerApp(HPayKey.WX_APP_ID);
    }

    public static void handleOnResp(BaseResp resp) {
        L.d(TAG, " ====  handleOnResp ,resp:" + resp.toString() + " === ");
        if (resp.getType() == 5 && resp.errCode == 0) {
            if (null != mListener) {
                mListener.onPaySuccess();
            }
        } else if (null != mListener) {
            mListener.onPayFail(String.valueOf(resp.errCode), resp.errStr);
        }
    }

    public static void handleOnReq(BaseReq req) {
        L.d(TAG, " ====== handleonReq =====");
    }

    public static void handleIntent(Intent intent, Context context) {
    }
}

