/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns.util;

import com.relayrides.pushy.apns.util.ApnsPayloadBuilder;
import java.util.ArrayList;
import org.apache.commons.lang3.RandomStringUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Thread)
public class ApnsPayloadBuilderBenchmark {
    private ApnsPayloadBuilder apnsPayloadBuilder;
    private static final int MAXIMUM_PAYLOAD_SIZE = 4096;
    @Param(value={"512", "8192"})
    public int messageBodyLength;
    @Param(value={"BASIC_LATIN", "CJK_UNIFIED_IDEOGRAPHS"})
    public String unicodeBlockName;
    private String messageBody;

    @Setup
    public void setUp() {
        this.apnsPayloadBuilder = new ApnsPayloadBuilder();
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.forName(this.unicodeBlockName);
        ArrayList<Character> charactersInBlock = new ArrayList<Character>();
        for (int codePoint = 0; codePoint < 0x10FFFF; ++codePoint) {
            if (!unicodeBlock.equals(Character.UnicodeBlock.of(codePoint)) || Character.isISOControl(codePoint)) continue;
            charactersInBlock.add(Character.valueOf((char)codePoint));
        }
        char[] messageBodyCharacters = new char[charactersInBlock.size()];
        for (int i = 0; i < charactersInBlock.size(); ++i) {
            messageBodyCharacters[i] = ((Character)charactersInBlock.get(i)).charValue();
        }
        this.messageBody = RandomStringUtils.random((int)this.messageBodyLength, (char[])messageBodyCharacters);
    }

    @Benchmark
    public String testBuildWithMaximumLength() {
        this.apnsPayloadBuilder.setAlertBody(this.messageBody);
        return this.apnsPayloadBuilder.buildWithMaximumLength(4096);
    }
}

