/*
 * Decompiled with CFR 0.152.
 */
package com.swak.rxtx;

import com.swak.closable.ShutDownHook;
import com.swak.reactivex.threads.Contexts;
import com.swak.reactivex.threads.ScheduledContext;
import com.swak.rxtx.Builder;
import com.swak.rxtx.channel.Channel;
import com.swak.rxtx.channel.EventLoopGroup;
import com.swak.rxtx.utils.SerialUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Channels {
    private static Channels _ME = null;
    protected static Logger logger = LoggerFactory.getLogger(Channel.class);
    protected Map<String, Channel> channels;
    protected Heartbeat heartbeat;
    protected EventLoopGroup eventLoops;
    protected Consumer<Channel> channelInit;
    private AtomicBoolean closed = new AtomicBoolean(true);

    public static Channels me() {
        return _ME;
    }

    public Channels(int works, int heartbeatSeconds, Consumer<Channel> channelInit) {
        this.channels = new ConcurrentHashMap<String, Channel>(works * 2);
        this.heartbeat = new Heartbeat(heartbeatSeconds);
        this.eventLoops = new EventLoopGroup(works);
        this.channelInit = channelInit;
        _ME = this;
        ShutDownHook.registerShutdownHook(() -> {
            this.close();
            this.heartbeat.shutdown();
            this.eventLoops.shutdown();
        });
    }

    public boolean isRunning() {
        return !this.closed.get();
    }

    public void start() {
        if (this.closed.compareAndSet(true, false)) {
            this.heartbeat.start();
        }
    }

    private void scanChannels() {
        List<String> comms = SerialUtils.getCommNames();
        if (comms != null && comms.size() > 0) {
            for (String comm : comms) {
                this.channels.computeIfAbsent(comm, v -> this.scanChannel(comm));
            }
        }
    }

    private Channel scanChannel(String comm) {
        Channel channel = new Channel(comm).register(this.eventLoops.next());
        if (this.channelInit != null) {
            this.channelInit.accept(channel);
        }
        return channel;
    }

    public void connect() {
        if (!this.closed.get()) {
            this.scanChannels();
            this.channels.forEach((comm, device) -> device.connect());
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.channels.forEach((comm, device) -> device.close());
            this.channels.values().removeIf(device -> !device.isActive());
        }
    }

    public void remove(Channel channel) {
        this.channels.remove(channel.comm());
    }

    private void heartbeat() {
        if (!this.closed.get()) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u8bbe\u5907\u5fc3\u8df3\uff0c\u8bbe\u5907\u6570:[{}]", (Object)this.channels.size());
            }
            this.scanChannels();
            this.channels.forEach((comm, channel) -> channel.heartbeat());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    class Heartbeat
    implements Runnable {
        private ScheduledContext heartbeat;
        private int heartbeatSeconds;

        public Heartbeat(int heartbeatSeconds) {
            this.heartbeatSeconds = heartbeatSeconds;
        }

        @Override
        public void run() {
            Channels.this.heartbeat();
        }

        private void start() {
            if (this.heartbeat == null && this.heartbeatSeconds > 0) {
                this.heartbeat = Contexts.createScheduledContext((String)"Channels.Heartbeat-", (int)1, (boolean)true, (long)60L, (TimeUnit)TimeUnit.SECONDS);
                this.heartbeat.scheduleAtFixedRate((Runnable)this, 0L, (long)this.heartbeatSeconds, TimeUnit.SECONDS);
            }
        }

        private void shutdown() {
            if (this.heartbeat != null) {
                this.heartbeat.shutdown();
            }
        }
    }
}

