/*
 * Decompiled with CFR 0.152.
 */
package com.swak.rxtx.channel;

import com.swak.rxtx.Channels;
import com.swak.rxtx.channel.ChannelPipeline;
import com.swak.rxtx.channel.EventLoop;
import com.swak.rxtx.enums.Status;
import com.swak.rxtx.utils.SerialUtils;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Channel {
    private static Logger logger = LoggerFactory.getLogger(Channel.class);
    private final String comm;
    private Property property;
    private EventLoop eventLoop;
    private SerialPort sport;
    private ChannelPipeline pipeline;
    private volatile Status status = Status.\u65ad\u5f00;
    private ByteBufAllocator alloc;

    public Channel property(Property property) {
        this.property = property;
        this.alloc = this.property.alloc;
        return this;
    }

    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    public String comm() {
        return this.comm;
    }

    public boolean isActive() {
        return this.status == Status.\u8fde\u63a5;
    }

    public Channel(String comm) {
        this.comm = comm;
        this.pipeline = new ChannelPipeline(this);
        this.property(new Property());
    }

    public Channel register(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
        return this;
    }

    public void connect() {
        if (!this.inEventLoop()) {
            this.eventLoop.execute(() -> this.connect());
        } else {
            if (this.sport != null) {
                this.close();
            }
            this.doConnect();
            if (this.isActive()) {
                this.pipeline.fireConnectEvent(this);
            } else {
                Channels.me().remove(this);
                this.pipeline.fireCloseEvent(this);
            }
        }
    }

    private void doConnect() {
        try {
            if (this.property == null) {
                logger.error("\u8bf7\u521d\u59cb\u5316\u8bbe\u5907\u8fde\u63a5\u5c5e\u6027\uff1a[{}]", (Object)this.comm);
                return;
            }
            this.sport = SerialUtils.connect(this.comm, this.property.baudRate, this.property.dataBit, this.property.stopBit, this.property.parityBit);
            this.sport.setInputBufferSize(this.property.readBufferSize);
            this.sport.setOutputBufferSize(this.property.writeBufferSize);
            this.sport.addEventListener(event -> this.autoRead(event));
            this.sport.notifyOnDataAvailable(true);
            this.sport.notifyOnCTS(true);
            this.sport.notifyOnDSR(true);
            this.sport.notifyOnRingIndicator(true);
            this.sport.notifyOnCarrierDetect(true);
            this.sport.notifyOnOverrunError(true);
            this.sport.notifyOnParityError(true);
            this.sport.notifyOnFramingError(true);
            this.sport.notifyOnBreakInterrupt(true);
            this.status = Status.\u8fde\u63a5;
            if (logger.isDebugEnabled()) {
                logger.debug("\u8bbe\u5907\u4e0a\u7ebf\uff1a[{}]", (Object)this.comm);
            }
        }
        catch (PortInUseException e) {
            this.status = Status.\u65ad\u5f00;
        }
        catch (NoSuchPortException e) {
            this.status = Status.\u65ad\u5f00;
        }
        catch (Exception e) {
            logger.error("\u8fde\u63a5\u4e32\u53e3\u8bbe\u5907\u5f02\u5e38\uff1a[{}]", (Object)this.comm, (Object)e);
            this.status = Status.\u65ad\u5f00;
        }
    }

    private void autoRead(SerialPortEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u6536\u5230\u8bbe\u5907\u4e8b\u4ef6\uff1a[{}]\uff0c\u4e8b\u4ef6:[{}]", (Object)this.comm, (Object)event.getEventType());
        }
        if (1 != event.getEventType()) {
            return;
        }
        this.read();
    }

    private void read() {
        if (!this.inEventLoop()) {
            this.eventLoop.execute(() -> this.read());
        } else {
            this.doRead();
        }
    }

    private void doRead() {
        try {
            int len;
            this.sport.notifyOnDataAvailable(false);
            do {
                ByteBuf byteBuf = this.alloc.buffer(this.property.readSizeOnce);
                len = byteBuf.writeBytes(this.sport.getInputStream(), byteBuf.capacity());
                if (logger.isDebugEnabled()) {
                    logger.debug("\u6536\u5230\u8bbe\u5907\u53cd\u9988\uff1a[{}]\uff0c\u8bfb\u53d6\u6570\u636e\u957f\u5ea6:[{}]", (Object)this.comm, (Object)len);
                }
                this.pipeline.fireReadEvent(this, byteBuf);
            } while (len > 0);
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u4e32\u53e3\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            this.status = Status.\u5f02\u5e38;
        }
        finally {
            this.sport.notifyOnDataAvailable(true);
        }
    }

    public void write(Object data) {
        if (!this.inEventLoop()) {
            this.eventLoop.execute(() -> this.write(data));
        } else {
            this.pipeline.fireWriteEvent(this, data);
        }
    }

    public void heartbeat() {
        if (!this.inEventLoop()) {
            this.eventLoop.execute(() -> this.heartbeat());
        } else {
            if (this.status == Status.\u65ad\u5f00) {
                this.connect();
                return;
            }
            this.pipeline.fireHeartbeatEvent(this);
        }
    }

    void writeAndFlush(Object data) {
        if (!this.inEventLoop()) {
            this.eventLoop.execute(() -> this.writeAndFlush(data));
        } else {
            try {
                if (this.status == Status.\u65ad\u5f00) {
                    logger.error("\u8bbe\u5907\u5df2\u7ecf\u65ad\u5f00");
                    return;
                }
                byte[] command = null;
                if (data instanceof byte[]) {
                    command = (byte[])data;
                }
                if (command == null) {
                    logger.error("\u547d\u4ee4\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f6c\u4e3a\u5b57\u8282\u6570\u7ec4");
                    return;
                }
                OutputStream outputStream = this.sport.getOutputStream();
                outputStream.write(command);
                outputStream.flush();
                if (logger.isDebugEnabled()) {
                    logger.debug("\u53d1\u9001\u547d\u4ee4\u7ed9\u8bbe\u5907\uff1a[{}], \u547d\u4ee4\u957f\u5ea6:[{}]", (Object)this.comm, (Object)command.length);
                }
            }
            catch (IOException e) {
                logger.error("\u53d1\u9001\u4fe1\u606f\u5230\u4e32\u53e3\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                this.status = Status.\u65ad\u5f00;
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u4fe1\u606f\u5230\u4e32\u53e3\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                this.status = Status.\u5f02\u5e38;
            }
        }
    }

    public void close() {
        if (!this.inEventLoop()) {
            this.eventLoop.execute(() -> this.close());
        } else {
            try {
                if (this.sport != null && this.status != Status.\u65ad\u5f00) {
                    this.sport.notifyOnDataAvailable(false);
                    this.sport.removeEventListener();
                    this.sport.close();
                    this.sport = null;
                    this.status = Status.\u65ad\u5f00;
                    this.pipeline.fireCloseEvent(this);
                }
                this.sport = null;
                this.status = Status.\u65ad\u5f00;
                if (logger.isDebugEnabled()) {
                    logger.debug("\u8bbe\u5907\u5173\u95ed\uff1a[{}]", (Object)this.comm);
                }
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u4fe1\u606f\u5230\u4e32\u53e3\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public boolean inEventLoop() {
        return this.eventLoop.inEventLoop();
    }

    public void execute(Runnable task) {
        this.eventLoop.execute(task);
    }

    public static class Property {
        private int baudRate = 9600;
        private int dataBit = 8;
        private int stopBit = 1;
        private int parityBit = 0;
        private int readBufferSize = 8192;
        private int writeBufferSize = 1024;
        private int readSizeOnce = 10;
        private ByteBufAllocator alloc = PooledByteBufAllocator.DEFAULT;

        public int getBaudRate() {
            return this.baudRate;
        }

        public int getDataBit() {
            return this.dataBit;
        }

        public int getStopBit() {
            return this.stopBit;
        }

        public int getParityBit() {
            return this.parityBit;
        }

        public int getReadBufferSize() {
            return this.readBufferSize;
        }

        public int getWriteBufferSize() {
            return this.writeBufferSize;
        }

        public int getReadSizeOnce() {
            return this.readSizeOnce;
        }

        public ByteBufAllocator getAlloc() {
            return this.alloc;
        }

        public Property setBaudRate(int baudRate) {
            this.baudRate = baudRate;
            return this;
        }

        public Property setDataBit(int dataBit) {
            this.dataBit = dataBit;
            return this;
        }

        public Property setStopBit(int stopBit) {
            this.stopBit = stopBit;
            return this;
        }

        public Property setParityBit(int parityBit) {
            this.parityBit = parityBit;
            return this;
        }

        public Property setReadBufferSize(int readBufferSize) {
            this.readBufferSize = readBufferSize;
            return this;
        }

        public Property setWriteBufferSize(int writeBufferSize) {
            this.writeBufferSize = writeBufferSize;
            return this;
        }

        public Property setReadSizeOnce(int readSizeOnce) {
            this.readSizeOnce = readSizeOnce;
            return this;
        }

        public Property setAlloc(ByteBufAllocator alloc) {
            this.alloc = alloc;
            return this;
        }
    }
}

